#ifndef PRINT_H
#define PRINT_H

typedef struct {
  char *name;
  int width;
  int height;
} Papersize;

typedef enum {PaperLandscape,PaperPortrait} PaperOrientation;

/* Paper sizes. Name, width and height (in points) */
static const Papersize papersize[]={
  {"Comm #10 Envelope",	297, 684},
  {"C5 Envelope",	461, 648},
  {"DL Envelope",	312, 624},
  {"Folio",		595, 935},
  {"Executive",		522, 756},
  {"Letter",		612, 792},
  {"Legal",		612, 1008},
  {"Ledger",		1224,792},
  {"Tabloid",		792, 1224},
  {"A0",		2384,3370},
  {"A1",		1684,2384},
  {"A2",		1191,1684},
  {"A3",		842 ,1191},
  {"A4",		595 ,842},
  {"A5",		420 ,595},
  {"A6",		297 ,420},
  {"A7",		210 ,297},
  {"A8",		148 ,210},
  {"A9",		105 ,148},
  {"B0",		2920,4127},
  {"B1",		2064,2920},
  {"B2",		1460,2064},
  {"B3",		1032,1460},
  {"B4",		729 ,1032},
  {"B5",		516 ,729},
  {"B6",		363 ,516},
  {"B7",		258 ,363},
  {"B8",		181 ,258},
  {"B9",		127 ,181},
  {"B10",		91 , 127}
};

#define PAPERSIZES 30

extern void print_to_file(char *filename,PaperOrientation orientation,int paperw,int paperh,double top,double bottom,double left,double right,Boolean header);

#endif
