#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <Xm/DialogS.h>
#include <Xm/PushBG.h>
#include <Xm/PushB.h>
#include <Xm/LabelG.h>
#include <Xm/PanedW.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>
#include <Xm/ComboBox.h>
#include <Xm/ToggleB.h>
#include "main.h"
#include "help_cb.h"
#include "cursor.h"
#include "message_dialog.h"
#include "images.h"
#include "print_dialog.h"
#include "util.h"
#include "print.h"

/* For debugging purposes: */
/* Uncomment this to disable printing */
//#define NO_REAL_PRINT "test.ps"

static void print_pushed (Widget w, XtPointer client_data, XtPointer call_data);

void print_dialog(void) {
  Widget dialog,pane,rc;
  Widget papersize_l,papersize_b,orientation_l,orientation;
  Widget label_g,action_a,text_w;
  Widget header_c;
  Widget marginbox,marginlabel,marginform;
  Widget marginl1,marginl2,marginl3,marginl4;
  Widget margint1,margint2,margint3,margint4;
  XmString string,string2;
  int n,i;
  Arg args[10];
  static ActionAreaItem  action_items[] = {
    {"Print",print_pushed,NULL},
    {"Cancel", unmanage_cb, NULL},
    {"Help",help_cb, "Print all the images that are loaded\nin the current viewmode"} 
  };
  /* Create DialogShell */
  n = 0;
#ifdef NO_REAL_PRINT
  XtSetArg (args[n], XmNtitle, "Print (to file)"); n++;
#else
  XtSetArg (args[n], XmNtitle, "Print"); n++;
#endif
  XtSetArg (args[n], XmNdeleteResponse, XmDESTROY); n++;
  dialog = XmCreateDialogShell (toplevel, "print_dialog", args, n);    
  action_items[0].data = (XtPointer) dialog;
  action_items[1].data = (XtPointer) dialog;
  /* Create control area */
  n = 0;
  XtSetArg (args[n], XmNsashWidth, 1); n++;
  XtSetArg (args[n], XmNsashHeight, 1); n++;
  pane = XmCreatePanedWindow (dialog, "pane", args, n);
  rc = XmCreateRowColumn (pane, "control_area", NULL, 0);
  /* Create paper size label */
  string=XmStringCreateLocalized("Paper size:");
  n=0;
  XtSetArg(args[n],XmNlabelString,string);n++;
  papersize_l=XmCreateLabelGadget(rc,"papersizelabel",args,n);
  XmStringFree(string);
  XtManageChild(papersize_l);
  /* Create the papersize selection box */
  n=0;
  XtSetArg(args[n],XmNpositionMode,XmZERO_BASED);n++;
  papersize_b=XmCreateDropDownList(rc,"papersize",args,n);
  XtManageChild(papersize_b);
  for(i=0;i<PAPERSIZES;i++) {
    string=XmStringCreateLocalized(papersize[i].name);
    XmComboBoxAddItem(papersize_b,string,-1,FALSE);
    XmStringFree(string);
  }
  string=XmStringCreateLocalized("A4");
  XmComboBoxSelectItem(papersize_b,string);
  XmStringFree(string);
  string=XmStringCreateLocalized("Orientation:");
  n=0;
  XtSetArg(args[n],XmNlabelString,string);n++;
  orientation_l=XmCreateLabelGadget(rc,"orientationlabel",args,n);
  XmStringFree(string);
  XtManageChild(orientation_l);
  /* Create the orientation selection box */
  string=XmStringCreateLocalized("Landscape");
  string2=XmStringCreateLocalized("Portrait");
  orientation=XmVaCreateSimpleRadioBox(rc,"orientation",1,NULL,
  	XmVaRADIOBUTTON,string,NULL,NULL,NULL,
	XmVaRADIOBUTTON,string2,NULL,NULL,NULL,
	NULL);
  XtManageChild(orientation);
  XmStringFree(string);
  XmStringFree(string2);
  /* Create the header checkbox */
  string=XmStringCreateLocalized("Print header");
  header_c=XmCreateToggleButton(rc,"header",NULL,0);
  n=0;
  XtSetArg(args[n],XmNlabelString,string); n++;
  XtSetArg(args[n],XmNset,XmSET); n++;
  XtSetValues(header_c,args,n);
  XmStringFree(string);
  XtManageChild(header_c);
  /* Create printer name label */
  string = XmStringCreateLocalized ("Printer name:");
  n = 0;
  XtSetArg (args[n], XmNlabelString, string); n++;
  label_g = XmCreateLabelGadget (rc, "printernamelabel", args, n);
  XmStringFree (string);
  XtManageChild (label_g);
  /* Create printer name textfield */
  n=0;
  XtSetArg (args[n], XmNvalue, printer_name); n++;
  text_w = XmCreateTextField (rc, "printername", args, n);
#ifdef NO_REAL_PRINT
  XtSetSensitive(text_w,False);
#endif
  XtManageChild (text_w);
  /* Create the page margins box */
  marginbox=XmCreateFrame(rc,"marginbox",NULL,0);
  XtManageChild(marginbox);
  n = 0;
  XtSetArg (args[n], XmNframeChildType, XmFRAME_TITLE_CHILD); n++;
  XtSetArg (args[n], XmNchildVerticalAlignment, XmALIGNMENT_BEGINNING); n++;
  marginlabel = XmCreateLabelGadget (marginbox, "Page margins (inches)", args, n);
  XtManageChild (marginlabel);
  n=0;
  marginform = XmCreateForm (marginbox, "marginform", args, n);
  /* Create marginbox contents */
  n=0;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  marginl1=XmCreateLabelGadget(marginform,"Top:    ",args,n);
  XtSetArg(args[n-1],XmNleftAttachment,XmATTACH_WIDGET); n++;
  XtSetArg(args[n],XmNleftWidget,marginl1); n++;
  marginl2=XmCreateLabelGadget(marginform,"Bottom:",args,n);
  XtSetArg(args[n-1],XmNleftWidget,marginl2);
  marginl3=XmCreateLabelGadget(marginform,"Left:  ",args,n);
  XtSetArg(args[n-1],XmNleftWidget,marginl3);
  marginl4=XmCreateLabelGadget(marginform,"Right: ",args,n);
  n=0;
  XtSetArg(args[n],XmNvalue,"0.5"); n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_WIDGET); n++;
  XtSetArg(args[n],XmNtopWidget,marginl1); n++;
  XtSetArg(args[n],XmNrightWidget,marginl2); n++;
  margint1=XmCreateText (marginform, "mtop", args, n);
  XtSetArg(args[n-4],XmNleftAttachment,XmATTACH_WIDGET);
  XtSetArg(args[n-2],XmNtopWidget,marginl2);
  XtSetArg(args[n-1],XmNrightWidget,marginl3);
  XtSetArg(args[n],XmNleftWidget,margint1); n++;
  margint2=XmCreateText (marginform, "mbottom", args, n);
  XtSetArg(args[n-3],XmNtopWidget,marginl3);
  XtSetArg(args[n-2],XmNrightWidget,marginl4);
  XtSetArg(args[n-1],XmNleftWidget,margint2);
  margint3=XmCreateText (marginform, "mleft", args, n);
  XtSetArg(args[n-3],XmNtopWidget,marginl4);
  XtSetArg(args[n-4],XmNrightAttachment,XmATTACH_NONE);
  XtSetArg(args[n-1],XmNleftWidget,margint3);
  margint4=XmCreateText (marginform, "mright", args, n);
  XtManageChild(marginl1);
  XtManageChild(marginl2);
  XtManageChild(marginl3);
  XtManageChild(marginl4);
  XtManageChild(margint1);
  XtManageChild(margint2);
  XtManageChild(margint3);
  XtManageChild(margint4);
  /* RowColumn is full -- now manage */
  XtManageChild (marginform);
  XtManageChild (rc);
  /* Create the action area. */
  action_a = CreateActionArea (pane, action_items,XtNumber (action_items));
  XtManageChild (pane);
}

static void print_pushed (Widget w, XtPointer client_data, XtPointer call_data) {
  Widget printername_t,papersize_c,landscape_b,mt,mb,ml,mr,header;
  PaperOrientation po;
#ifndef NO_REAL_PRINT 
  char cmdline[256];
#endif
  char tmpname[L_tmpnam];
  Boolean orientation,pheader;
  char *name,*top,*bottom,*left,*right;
  int index;
  printername_t=XtNameToWidget((Widget)client_data,"*printername");
  papersize_c=XtNameToWidget((Widget)client_data,"*papersize");
  landscape_b=XtNameToWidget((Widget)client_data,"*orientation.button_0");
  mt=XtNameToWidget((Widget)client_data,"*mtop");
  mb=XtNameToWidget((Widget)client_data,"*mbottom");
  ml=XtNameToWidget((Widget)client_data,"*mleft");
  mr=XtNameToWidget((Widget)client_data,"*mright");
  header=XtNameToWidget((Widget)client_data,"*header");
  name=XmTextFieldGetString(printername_t);
  XtVaGetValues(papersize_c,XmNselectedPosition,&index,NULL);
  orientation=XmToggleButtonGetState(landscape_b);
  if(orientation) po=PaperLandscape; else po=PaperPortrait;
  pheader=XmToggleButtonGetState(header);
  top=XmTextGetString(mt);
  bottom=XmTextGetString(mb);
  left=XmTextGetString(ml);
  right=XmTextGetString(mr);
  /* Print */
  if(get_image_list()==NULL) {
    message_dialog("No images loaded !","Print");
    unmanage_cb(w,client_data,NULL);
    return;
  }
  my_SetWatchCursor(toplevel);
  my_SetWatchCursor((Widget)client_data);

#ifndef NO_REAL_PRINT
  tmpnam(tmpname);
#else
  printf("(not really)\n");
  strcpy(tmpname,NO_REAL_PRINT);
#endif
  print_to_file(tmpname,po,papersize[index].width,papersize[index].height,atof(top),atof(bottom),atof(left),atof(right),pheader);
#ifndef NO_REAL_PRINT
  printf("Printing temp file \"%s\" to printer \"%s\"...\n",tmpname,name);
  sprintf(cmdline,"lpr -P%s %s",name,tmpname);
  system(cmdline);
  unlink(tmpname);
#endif
  my_ResetCursor(toplevel);
  /* Cleanup */
  XtFree (name);
  unmanage_cb(w,client_data,NULL);
}

