/* In read_arg.c read_arg function reads 
 * frames and planes user has given 
 */
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <stdlib.h>
#include <stdio.h>
#include <ecat63.h>
#include "main.h"
#include "cursor.h"
#include "message_dialog.h"
#include "images.h"
#include "zoom_images.h"
#include "close_file.h"
#include "read_arg.h"
#include "roilist.h"

/* Maximium number of matrices to load */
#define MAX_MATRICES 200

/* Get out of zoom, clear old images and then call read_arg */
void re_read_arg(Widget w, XtPointer client_data, XtPointer call_data) {
  if(zoom_matrix.zoom>0)
    zoom_stop(0);
  clear_display_area();
  read_arg(w,client_data,call_data);
}

/* Load the selected frames and planes */
void read_arg(Widget w, XtPointer client_data, XtPointer call_data)
{
  int                           i;
  char                          *plane_str=NULL, *frame_str;
  XmSelectionBoxCallbackStruct  *cbs=
      (XmSelectionBoxCallbackStruct *) call_data;
  Study	*study=(Study*)client_data;
  char                          test[2];
 
  /* read user's string (given in selection dialog) to frame
   */
  if(!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &frame_str))
    return;
  printf("read_arg(): selection=%s\n",frame_str ); 

  my_SetWatchCursor(toplevel);
  my_SetWatchCursor(w);

  strcat(frame_str, " ");
  switch(strlen(frame_str)){
     case 1:
       strcpy(frame_str, "all");
       plane_str = (char*)malloc(512*(sizeof(char)));
       strcpy(plane_str, "all");
       break;
     case 2:
       strncpy(test, frame_str, 1);
       if(atoi(test)==0)strcpy(frame_str, "all");
       plane_str = (char*)malloc(512*(sizeof(char)));
       strcpy(plane_str, "all");
       break;
     default:
       /* In one argument (=frame) we have frames & planes
        * Try to separate them.
        */ 
       if(strlen(frame_str)>2){
         plane_str=strchr(frame_str, ' ');
         if(plane_str!=NULL){*plane_str=(char)0; plane_str++;}

         strncpy(test, frame_str, 1);
         if(atoi(test)==0)strcpy(frame_str, "all");
         if(strlen(plane_str)>0){
           strncpy(test, plane_str, 1);
           if(atoi(test)==0)strcpy(plane_str, "all");
          }
        } else {
          strcpy(frame_str, "all");
          plane_str = (char*)malloc(512*(sizeof(char)));
          strcpy(plane_str, "all");
        }
       break;
  }
 
 //printf("frame:%s   plane:%s\n", frame_str, plane_str);
  strncpy(test, plane_str, 1);
  if(atoi(test)==0)strcpy(plane_str, "all");

  /* if user has not given planes, all planes will be plotted */
  if(strcmp(plane_str, "all")==0){
    /* Allocate memory for study->planelist.i vector */
     study->planelist.i=(int*)malloc(study->imagepack.dimz*(sizeof(int)));
    /* Write plane numbers to study->planelist.i vector */ 
     study->planelist.nr=study->imagepack.dimz;
     for(i=0; i<study->imagepack.dimz; i++)
       study->planelist.i[i]=study->imagepack.planeNumber[i];
  }
  else{
     study->planelist.nr=0;
     intExpand(plane_str, &study->planelist);
  }


  /* if user has not given frames, all frames will be plotted */
  if(strcmp(frame_str, "all")==0){
    sprintf(frame_str, "1-%d", study->imagepack.dimt);
  }
  /*Initialize frame and plane lists */
  study->framelist.nr=0; 
  intExpand(frame_str, &study->framelist);

  /* Free used memory*/
  //if(plane_str!=NULL)free(plane_str);
  free(frame_str);
  
  /* Limit the number of matrices to load. */
  /* (This is to protect the user from accidentally loading a */
  /*  huge dynamic image that would fill up the entire memory */
  if(study->planelist.nr * study->framelist.nr > MAX_MATRICES){
     my_ResetCursor(toplevel);
     message_dialog("Attempted to load too many matrices !","Load images");
     my_ResetCursor(toplevel);
     my_ResetCursor(w);
     return;
  }

  zoom_matrix.frame=study->framelist.i[0]-1;
  zoom_matrix.plane=study->planelist.i[0]-1;
  
  /* Update the image list */
  update_image_list(study);
  
  /* Update ROI pairings */
  repair_rois(&roi_list);

  /* Write information to message_area */
  message_area_info();

  /* Enable menu entries */
  XtSetSensitive(XtNameToWidget(toplevel,"*filemenu.button_1"),True);		/* Open secondary study */
  XtSetSensitive(XtNameToWidget(toplevel,"*filemenu.button_2"),True);		/* Print */
  XtSetSensitive(XtNameToWidget(toplevel,"*filemenu.button_3"),True);		/* Export */
  XtSetSensitive(XtNameToWidget(toplevel,"*filemenu.button_4"),True);		/* Clear */
  XtSetSensitive(XtNameToWidget(toplevel,"*optionsmenu.button_2"),True);	/* Zoom */
  XtSetSensitive(XtNameToWidget(toplevel,"*optionsmenu.button_3"),True);	/* Select again */
  if(study==&studies[1])
    XtSetSensitive(XtNameToWidget(toplevel,"*optionsmenu.button_4"),True);	/* Select secondary again */
  
  my_ResetCursor(toplevel);
  my_ResetCursor(w);

  return;

}

void read_matrix_sel(char *matrix_str, INT_list *frame_list, INT_list *plane_list)
{
  char  *plane_str=NULL;
  int   i;

  //printf("%s\n", matrix_str);

 plane_str=strchr(matrix_str, ' ');
 if(plane_str!=NULL){
   *plane_str=(char)0; 
    plane_str++;
    //printf("%s\n", plane_str);
    plane_list->nr=0;
    intExpand(plane_str, plane_list); 
    printf(" planes: ");
    for(i=0; i<plane_list->nr; i++) printf("%d\t", plane_list->i[i]);

 }
 //printf("\n%s\n", matrix_str);

  frame_list->nr=0; 
  intExpand(matrix_str, frame_list);
  printf("\n frames: ");
  for(i=0; i<frame_list->nr; i++) printf("%d\t", frame_list->i[i]);
  printf("\n");

}
