#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "main.h"
#include "message_dialog.h"
#include "colortables.h"

static int split_string(char *str,char chr,char **left,char **right);

/* Read the configuration file */
int read_config(char *filename)
{

  char line[256];
  FILE *fp;
  char *left,*right;

  if((fp=fopen(filename, "r")) == NULL) {
    fprintf(stderr, "YaIT: cannot open configuration file (\"%s\").\n",filename);
    return 1;
  }
  while(fgets(line,sizeof(line),fp)) {
    if(split_string(line,'=',&left,&right)) continue;
    /*printf("\"%s\"\t\t\"%s\"\n",left,right);*/
    if(strcmp(left,"imagedir")==0) strcpy(directory,right);
    else if(strcmp(left,"colortable")==0 || strcmp(left,"colortable2")==0) {
      int ctN=strcmp(left,"colortable")!=0;
      if(strcmp(right,"gray")==0) studies[ctN].color=GRAYSCALE;
      else if(strcmp(right,"inverse")==0) studies[ctN].color=INVERSESCALE;
      else if(strcmp(right,"rainbow")==0) studies[ctN].color=RAINBOWSCALE;
      else if(strcmp(right,"heat")==0) studies[ctN].color=HEATSCALE;
      else if(strcmp(right,"aips")==0) studies[ctN].color=AIPSSCALE;
      else fprintf(stderr,"Unrecognized colortable \"%s\"\n",right);
    } else if(strcmp(left,"printer")==0) strcpy(printer_name,right);
    else if(strcmp(left,"interpolation")==0) zoom_matrix.interpolation=atoi(right);
    else if(strcmp(left,"scale")==0) {
      if(strcmp(right,"automatic")==0) panels.scale=ScaleAutomatic;
      else if(strcmp(right,"fixed")==0) panels.scale=ScaleFixed;
      else fprintf(stderr,"Unrecognized scale: \"%s\". Only \"automatic\" and \"fixed\" are supported.\n",right);
    } else if(strcmp(left,"negative")==0) panels.no_neg_values=!atoi(right);
    else if(strcmp(left,"roi_study")==0) {
      panels.save_roi_studyn=atoi(right);
      if(panels.save_roi_studyn<1 || panels.save_roi_studyn>2) {
        panels.save_roi_studyn=0;
	fprintf(stderr,"config: Strange value for roi_study (%s), support values are 1 or 2.\n",right);
      } else panels.save_roi_studyn--;
    }
    else if(strcmp(left,"imagesperrow")==0) imagesPerRow=atoi(right);
    else if(strcmp(left,"smoothroi")==0) panels.smoothroi=atoi(right);
    else fprintf(stderr,"Unrecognized setting: \"%s\"\n",left);
    free(left);
    free(right);
  }
  if(fclose(fp)) return -1;		/* Close conf file */
  return 0;
}

/* Split a string in two, separated by chr. Whitespace will be trimmed */
static int split_string(char *str,char chr,char **left,char **right) {
  char *begin=str;
  char *ptr,*end;
  if(str==NULL || strlen(str)==0) return 1;
  while(*begin==' ' || *begin=='\t' || *begin=='\n') begin++;
  if(*begin=='#' || *begin=='\0') return 1;
  ptr=strchr(str,chr);
  if(ptr==NULL) {
    printf("split_string(): Couldn't find '%c' from string \"%s\"\n",chr,str);
    return 1;
  }
  end=ptr-1;
  while(*end==' ' || *end=='\t' || *end=='\n') end--;
  end++;
  *left=malloc(end-begin+1);
  strncpy(*left,begin,end-begin);
  (*left)[end-begin]='\0';
  begin=ptr+1;
  while(*begin==' ' || *begin=='\t' || *begin=='\n') begin++;
  end=begin+strlen(begin)-1;
  while(*end==' ' || *end=='\t' || *end=='\n') end--;
  end++;
  *right=malloc(end-begin+1);
  strncpy(*right,begin,end-begin);
  (*right)[end-begin]='\0';
  return 0;
}

