#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include <ecat63.h>
#include "main.h"

#include "double_roi.h"
#include "roi_functions.h"
#include "scroll_list.h"
#include "move_roi.h"
#include "roi_dialog.h"
#include "zoom_images.h"
#include "roiutils.h"
#include "message_dialog.h"

void roi_menu_cb(Widget menu_item, XtPointer client_data, XtPointer call_data) {
  switch((int)client_data) {
    case 4: /* List ROIs dialog */
      scroll_list_rois();
      break;
    case 5: {/* Show/hide ROIs in matrix view */
        ImageList *list=get_image_list();
        Arg arg[1];
        panels.show_matrix_rois=!panels.show_matrix_rois;
        XtSetArg(arg[0],petimageNROI,panels.show_matrix_rois?&roi_list:NULL);
        while(list) {
          XtSetValues((Widget)list->img->widget,arg,1);
          list=list->next;
        }
      }
      break;
    case 6: {/* Enable/disable smooth ROI scaling */
            ZoomImage *zimg;
            panels.smoothroi = !panels.smoothroi;
            zimg=get_zoom_image();
            PetimageFlush(zimg->widget[0]);
            PetimageFlush(zimg->widget[1]);
          
      }
      break;
    default:
      fprintf(stderr,"roi_menu_cb(): Unknown menu item '%d' !\n",(int)client_data);
      break;
  }
}

void roi_draw_cb(Widget menu_item, XtPointer client_data, XtPointer call_data)
{
  ROI		     *roi;
  roi_userdata	     *userdata;
  if(zoom_matrix.zoom<1) return; /* ROIs can only be drawn in the zoom mode */
  if(strlen(studies[0].filename)<4) return;
  /* Cancel existing ROI drawmode */
  set_ROI_drawmode(NULL,-1);
  /* Create new ROI */
  roi=(ROI*)malloc(sizeof(ROI));
  memset(roi, 0, sizeof(ROI));
  userdata=(roi_userdata*)malloc(sizeof(roi_userdata));
  memset(userdata,0,sizeof(roi_userdata));
  userdata->extra_study=-1;
  strcpy(roi->imgfile, studies[0].filename);
  
  roi->zoom=zoom_matrix.zoom;
  roi->userdata=userdata;

  switch((int)client_data){
    case 0:
      printf("Trace ROI selected\n");
      roi->type=ROI_TRACE;
      set_ROI_drawmode(roi,ROI_TRACE);
      break;
    case 1:
      printf("Rectangular ROI selected\n");
      roi->type=ROI_RECTANGULAR;
      set_ROI_drawmode(roi,ROI_RECTANGULAR);
      break;
    case 2:
      printf("Circle ROI selected\n");
      roi->type=ROI_CIRCULAR;
      set_ROI_drawmode(roi,ROI_CIRCULAR);
      break;
    case 3:
      printf("Ellipse ROI selected\n");
      roi->type=ROI_ELLIPSE;
      set_ROI_drawmode(roi,ROI_ELLIPSE);
      break;
    default:
      fprintf(stderr,"roi_draw_cb(): Unknown item_no '%d' !\n",(int)client_data);
      break;
  }
}

void roi_tools_cb(Widget menu_item, XtPointer client_data, XtPointer call_data)
{
  ROI		     *roi;
  if(zoom_matrix.zoom<1) return; /* ROIs can only be handled in the zoom mode */
  if(strlen(studies[0].filename)<4) return;
  /* Cancel existing ROI drawmode */
  set_ROI_drawmode(NULL,-1);
  XtVaGetValues((Widget)get_zoom_image_widget(),petimageNselectedRoi,&roi,NULL);

  switch((int)client_data){
    case 0:
      printf("Move ROI selected\n");
      set_ROI_drawmode(NULL,ROI_MOVE);
      break;
    case 1:
      printf("Copy ROI selected\n");
      select_copy_roi();
      break;
    case 2:
      printf("Mirror copy ROI selected\n");
      select_mirrorcopy_roi();
      break;
    case 3:
      printf("Double the ROI selected\n");
      set_ROI_drawmode(NULL,ROI_DOUBLE);
      break;
    case 4:
      printf("Convert to Trace ROI selected\n");
      if(!roi)
        message_dialog("Please select a ROI first","Convert to Trace ROI");
      else if(roi->type==ROI_TRACE)
        message_dialog("ROI is already Trace ROI type","Convert to Trace ROI");
      else
        roi_convert_dialog(roi);
      break;
    case 5:
      printf("Rotate ROI selected\n");
      set_ROI_drawmode(NULL,ROI_ROTATE);
      break;
    case 6:
      printf("Profile selected\n");
      set_ROI_drawmode(NULL,ROI_PROFILE);
      break;
    default:
      fprintf(stderr,"roi_tools_cb(): Unknown item_no '%d' !\n",(int)client_data);
      break;
  }
}

void roi_file_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
  switch((int)client_data){
    case 0:
      printf("Save ROI selected\n");
      roi_save_dialog();
      break;
    case 1:
      printf("Load ROI selected\n");
      roi_read_dialog();
      break;
    default:
      fprintf(stderr,"roi_file_cb(): Unknown item_no '%d' !\n",(int)client_data);
      break;
  } 
}

void roi_saveto_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  if((int)client_data>1) {
    fprintf(stderr,"roi_saveto_cb(): Strange client_data (%d)\n",(int)client_data);
    return;
  }
  panels.save_roi_studyn=(int)client_data;
}
