#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/List.h>
#include <ecat63.h>
#include "main.h"
#include "deviation.h"
#include "file_cb.h"
#include "help_cb.h"
#include "list_cb.h"
#include "roi_dialog.h"
#include "roiutils.h"
#include "roi_functions.h"
#include "roilist.h"
#include "scroll_list.h"
#include "message_dialog.h"
#include "zoom_images.h"
#include "util.h"

/* A structure to hold information on what ROIs to save */
typedef struct {
  char *filename;
  int *selections;
  int count;
} save_roi_info;

/* Internally used functions */
static void name_roi_cb(Widget widget, XtPointer client_data, XtPointer call_data);
static void rename_cb(Widget widget, XtPointer client_data, XtPointer call_data);
static void read_roifile_cb(Widget widget, XtPointer client_data, XtPointer call_data);
static void save_roilist_cb(Widget widget, XtPointer client_data, XtPointer call_data);
static void append_roilist_cb(Widget widget, XtPointer client_data, XtPointer call_data)
;

static void cancel_roi(Widget dialog,XtPointer client_data,XtPointer call_data) {
  ROI *roi=(ROI*)client_data;
  XtUnmanageChild(dialog);
  free(roi->x);
  free(roi->y);
  free(roi);
  PetimageUpdate(get_zoom_image()->widget[0]);
  PetimageUpdate(get_zoom_image()->widget[1]);

}

/*
 *  Create dialog to give ROI name
 */
void name_roi_dialog(char *message,ROI *roi) {
  XmString name,title;
  Widget dialog;
  Arg args[2];
  int n=0;
  name=XmStringCreateLocalized(message);
  title=XmStringCreateLocalized("Give name to ROI");
  XtSetArg(args[n],XmNselectionLabelString,name); n++;
  XtSetArg(args[n],XmNdialogTitle,title); n++;
  dialog = XmCreatePromptDialog(toplevel,"roi_name",args,n);
  XmStringFree(name);
  XmStringFree(title);

  /* When the user types frame, plane and gate, call read_me()*/
  XtAddCallback(dialog, XmNokCallback, name_roi_cb, roi);
   
  /* If the user selects cancel, destroy the dialog and free the roi */
  XtAddCallback(dialog, XmNcancelCallback, cancel_roi, roi);
  /* Help */   
  XtAddCallback(dialog, XmNhelpCallback, help_cb, "Give name to this ROI.\nPressing cancel here will delete the new ROI.");
 
  XtManageChild(dialog);
}

/*
 * Copy the ROI to roi_list.
 */
static void name_roi_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  char                          *roiname, message[256];
  ROI				*roi=client_data;
  RoiList			*list;
  XmSelectionBoxCallbackStruct  *cbs=
    (XmSelectionBoxCallbackStruct *) call_data;

  printf("name_roi_cb()\n");

  if(!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &roiname))
      return;
  XtUnmanageChild(widget); 
 
  /* Check that user really gave a string for roiname 
   */
  if(strlen(roiname)<1){
        if(roiname!=NULL) XtFree(roiname);
	name_roi_dialog("Roiname is not acceptable.\n Give a real name.",roi);
	return;
  }

  /* Check that there isn't same roiname yet on the list
   */  
  list=roi_list.rois;
  while(list) {
    if ( !strcmp(roiname, list->roi->roiname) && (list->roi->matnum==roi->matnum)) {
        sprintf(message, " ROI: %s already exists.\n Give another name.\n", roiname);
        XtFree(roiname);
	name_roi_dialog(message,roi);
	return;
    }
    list=list->next;
  }
  /* Copy the acceptable roiname to the ROI struct */
  strcpy(roi->roiname, roiname);
  roi->status=0;

  /* Select the new ROI and add it to the ROI list */
  XtVaSetValues((Widget)get_zoom_image_widget(),
  	petimageNrequestRoi,put_roi_to_list(roi, &roi_list),
	NULL);

  /* Free used memory */
  if(roi->x)  free(roi->x);
  if(roi->y)  free(roi->y);
  free(roi);
 
  XtFree(roiname);

}

/* Convert ROI toi Trace ROI */
void roi_convert_dialog(ROI *roi) {
  Widget dialog;
  XmString t,ttl,ok,cancel;
  Arg args[5];
  int n=0;
  t=XmStringCreateLocalized("Convert selected ROI to Trace ROI ?");
  ttl=XmStringCreateLocalized("Confirm ROI conversion");
  ok=XmStringCreateLocalized("Yes");
  cancel=XmStringCreateLocalized("No");
  XtSetArg(args[n],XmNmessageString,t); n++;
  XtSetArg(args[n],XmNdialogTitle,ttl); n++;
  XtSetArg(args[n],XmNdefaultButtonType,XmDIALOG_OK_BUTTON); n++;
  XtSetArg(args[n],XmNokLabelString,ok); n++;
  XtSetArg(args[n],XmNcancelLabelString,cancel); n++;
  dialog = XmCreateQuestionDialog(toplevel,"convertroidlg",args,n);
  XtAddCallback(dialog,XmNokCallback,convertroi_cb,roi);
  XtUnmanageChild (XtNameToWidget (dialog, "Help"));

  XmStringFree(t);
  XmStringFree(ttl);
  XmStringFree(ok);
  XmStringFree(cancel);

  XtManageChild(dialog);
}

/* Rename ROI */
void rename_dialog(char *message, ROI *roi) {
  Arg                args[5];
  int                n = 0;  
  char               /*label[256],*/ prefilled_roiname[256];
  XmString           name, roiname,ttl;
  Widget             dialog;

  /*sprintf(label, "New name for ROI:'%s'", roi_list.roi[ind[0]-1].roiname );*/
  sprintf(prefilled_roiname, "%s", roi->roiname);
  /*name = XmStringCreateLocalized(label);*/
  name = XmStringCreateLocalized(message);
  roiname = XmStringCreateLocalized(prefilled_roiname);
  ttl = XmStringCreateLocalized("Rename ROI");
  /* Create dialog to rename selected ROI 
   */
  XtSetArg(args[n], XmNselectionLabelString, name); n++;
  XtSetArg(args[n], XmNtextString, roiname); n++;
  XtSetArg(args[n], XmNdialogTitle, ttl); n++;
  dialog = XmCreatePromptDialog(toplevel, "roi_rename", args, n);
  XmStringFree(name);
  XmStringFree(roiname);
  XmStringFree(ttl);
  /* When user selects ok, call rename_cb() */
  XtAddCallback(dialog, XmNokCallback, rename_cb, (XtPointer)roi);
   
  /* If the user selects cancel, just destroy the dialog */
  XtAddCallback(dialog, XmNcancelCallback, destroy_widget, NULL);
  /* help... */   
  XtAddCallback(dialog, XmNhelpCallback, help_cb, "Rename the selected ROI");

  XtManageChild(dialog);
	
}

static void rename_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{ 
  char                          *name, message[256];
  ROI                           *roi = (ROI *) client_data;
  RoiList			*list;
  XmSelectionBoxCallbackStruct  *cbs=
         (XmSelectionBoxCallbackStruct *) call_data;

  if(!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &name))
      return;

  /* Check that user really gave a string for roiname 
   */
  if(strlen(name)<1){
        sprintf(message, " Roiname is not acceptable.\n Give a real name.");
        if(name!=NULL) XtFree(name);
	rename_dialog(message, roi);
	return;
  }

  /* Check that there isn't same roiname yet on the list
   */  
  list=roi_list.rois;
  while(list) {
    if ( !strcmp(name, list->roi->roiname) && (list->roi->matnum==roi->matnum) ){
        sprintf(message, "Give another name for ROI!\n");
        if(name) XtFree(name);
	rename_dialog(message, roi);
	return;
    }
    list=list->next;
  }

  strcpy(roi->roiname, name);
  XtUnmanageChild(widget);
  XtFree(name);
}

/*
 * Create dialog to ask filename for depositing ROIs
 */
void roi_save_dialog()
{
  Widget     dialog;
  char              *dirtmp=NULL, *ftmp,dir[256],filename[256];
  Arg               args[5]; 
  XmString          file_mask, directory,ttl,default_filename;

  if(roi_list.nr<=0){
    message_dialog("There are no ROIs to save","Save ROI");
    return;
  }

  if(studies[0].filename[0]){
     dirtmp=strrchr(studies[0].filename, '/');
     strncpy(dir, studies[0].filename, strlen(studies[0].filename)-strlen(dirtmp)+1);
     dir[strlen(studies[0].filename)-strlen(dirtmp)+1]=(char)0;
     ftmp=strrchr(studies[0].filename,'.');
     strncpy(filename,dirtmp+1,ftmp-dirtmp-1);
     filename[ftmp-dirtmp-1]='\0';
     strcat(filename,".roi");
     default_filename=XmStringCreateLocalized(filename);
  } else default_filename=XmStringCreateLocalized("");

  
  /* Use file browser to select ROI file 
   */
  file_mask=XmStringCreateLocalized("*.roi");
  if(strlen(dir)>0){
    directory=XmStringCreateLocalized(dir);
  } 
  else directory=XmStringCreateLocalized("/");        
  ttl=XmStringCreateLocalized("Save ROI file");
  XtSetArg(args[0], XmNpathMode, XmPATH_MODE_RELATIVE);
  XtSetArg(args[1],XmNpattern, file_mask);
  XtSetArg(args[2], XmNdirectory, directory);
  XtSetArg(args[3],XmNdialogTitle,ttl);
  XtSetArg(args[4],XmNtextString,default_filename);

  dialog=XmCreateFileSelectionDialog(toplevel,"roifile_selection",
                                     args,5);
  XmStringFree(file_mask);
  XmStringFree(directory);
  XmStringFree(default_filename);
  XmStringFree(ttl);
  XtAddCallback(dialog, XmNcancelCallback, destroy_widget, NULL);
  XtAddCallback(dialog, XmNokCallback, select_save_roi, NULL); 
  /* Help */   
  XtAddCallback(dialog, XmNhelpCallback, help_cb,
	"Select the ROI file where to save ROIs.\n\
	After selecting the file, a dialog will pop up\n\
	asking which ROIs to save. If the file already exists,\n\
	you can choose either to overwrite it or append onto it.");
  XtManageChild(dialog);
  XtPopup(XtParent(dialog), XtGrabNone);
  XMapRaised(XtDisplay(dialog), XtWindow(XtParent(dialog)));
         

}

/* Check if the file exists. If it doesn't, write out data. If it does,
   popup a dialog asking wheter to overwrite or append
*/
void check_roifile(Widget widget, XtPointer client_data, XtPointer call_data)
{
  int				n;
  char                          message[256], *end=NULL;
  char                          *roifile = (char *)client_data;
  XmString                      overwrite, append, cancel, t;
  Widget                        dialog,selected_rois;
  Arg                           args[5]; 
  save_roi_info			*save;

  /* Check roi filename 
   */
  printf("check_roifile: roifile=%s\n", roifile);
  end=strrchr(roifile, '.');
  if(end==NULL || strcmp(end,".roi")){ 
      message_dialog("Suffixed the filename with \".roi\".","Saving ROI");
      strcat(roifile, ".roi");
  }
  /* Get selections */
  save=(save_roi_info*)malloc(sizeof(save_roi_info));
  save->filename=roifile;
  selected_rois=XtNameToWidget(widget,"*selectedrois");
  XmListGetSelectedPos(selected_rois,&save->selections,&save->count);

  if(save->count==0) {
    free(save);
    message_dialog("No ROIs were selected !","Save ROI");
    return;
  }
  /* access */
  if(access(roifile, 0) != -1) {
     sprintf(message, "Roifile:%s already exists.", roifile);
     t = XmStringCreateLocalized(message);
     overwrite = XmStringCreateLocalized("Overwrite");
     append = XmStringCreateLocalized("Append");
     cancel = XmStringCreateLocalized("Cancel");
     n = 0;
     XtSetArg (args[n], XmNokLabelString, overwrite); n++;
     XtSetArg (args[n], XmNcancelLabelString, append); n++;
     XtSetArg (args[n], XmNhelpLabelString, cancel); n++;
     XtSetArg (args[n], XmNmessageString, t); n++;
     dialog = XmCreateQuestionDialog (toplevel, "question", args, n);
     /* Add the callbacks to dialog buttons */
     XtAddCallback (dialog, XmNokCallback, save_roilist_cb, save);
     XtAddCallback (dialog, XmNcancelCallback, append_roilist_cb, save );
     XtAddCallback (dialog, XmNhelpCallback,  unmanage_cb, NULL );
    
     XmStringFree (t);
     XmStringFree (overwrite);
     XmStringFree (append);
     XmStringFree (cancel);

     XtManageChild (dialog);
  
  } else {
    printf("tiedostoa ei ole olemassa\n");
    append_roilist_cb(NULL,save,NULL);
  }
  
  XtUnmanageChild(widget);

}


/*
 * Overwrite the existing roifile
 */
void save_roilist_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  unlink(((save_roi_info*)client_data)->filename);
  append_roilist_cb(widget,client_data,call_data);
}


/*
 * Append to existing (or create a new) roifile
 */
void append_roilist_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
  save_roi_info *info=(save_roi_info*)client_data;
  RoiList	*rois=roi_list.rois;
  ROI		tmproi;
  FILE 		*fp;
  int pos=1,i=0;
  fp=fopen(info->filename,"a");
  if(!fp) {
    fprintf(stderr,"append_roilist_cb(): Cannot open file \"%s\", mode \"a\"\n",info->filename);
    error_dialog("Couldn't open ROI file for writing !");
    return;
  }
  for(i=0; i<info->count; i++) {
    while(pos<info->selections[i]) {
      rois=rois->next;
      pos++;
    }
    rois->roi->status=1;
    tmproi=*rois->roi;	/* Make a temporary copy of the ROI */
    if(tmproi.userdata && ((roi_userdata*)tmproi.userdata)->extra_study==0) { /* The ROI was not created in study 1 but we wan't to save it as if it was. */
      tmproi.matnum=((roi_userdata*)tmproi.userdata)->extra_matnum;
    }
    if(roi_append(fp,&tmproi)) {
      fprintf(stderr,"append_roilist_cb(): libpet, roi.c: %s\n",roierrmsg);
      error_dialog("Error occured while writing ROI !");
      return;
    }
  }
  fclose(fp);
  XtFree(info->filename);
  free(info->selections);
  free(info);
  if(widget) XtUnmanageChild(widget);
}


/*
 * Create dialog to ask filename for retrieving ROIs
 */
void roi_read_dialog()
{
  Arg               args[4];
  char              *dirtmp=NULL, dir[256];  
  static Widget     dialog=NULL;
  XmString          file_mask, directory,ttl;

  printf("roi_read_dialog\n");
  
  
  if(studies[0].filename[0]){
     dirtmp=strrchr(studies[0].filename, '/');
     strncpy(dir, studies[0].filename, strlen(studies[0].filename)-strlen(dirtmp)+1);
     dir[strlen(studies[0].filename)-strlen(dirtmp)+1]='\0';
  } else {
    dir[0]='\0';
  }
  if(dialog) {
    if(dir[0]){	    
        directory=XmStringCreateLocalized(dir);
        XtSetArg(args[0], XmNdirectory, directory);
        XtSetValues(dialog,args,1);
        XmStringFree(directory);
    }
  } else {
    file_mask=XmStringCreateLocalized("*.roi");
    if(dir[0]){	    
        directory=XmStringCreateLocalized(dir);
    }  else directory=XmStringCreateLocalized(".");
    ttl=XmStringCreateLocalized("Load ROI file");
    XtSetArg(args[0], XmNpathMode, XmPATH_MODE_RELATIVE);
    XtSetArg(args[1], XmNpattern, file_mask);
    XtSetArg(args[2], XmNdirectory, directory);
    XtSetArg(args[3], XmNdialogTitle, ttl);
    dialog=XmCreateFileSelectionDialog(toplevel,"roifile_selection",args,4);
    XmStringFree(file_mask);
    XmStringFree(directory);
    XmStringFree(ttl);
    XtAddCallback(dialog, XmNcancelCallback, unmanage_cb, NULL);
    XtAddCallback(dialog, XmNokCallback, read_roifile_cb, NULL);
    XtAddCallback(dialog, XmNhelpCallback, help_cb,"Select a file to load ROIs from.");
  }
  XtManageChild(dialog);
  XtPopup(XtParent(dialog), XtGrabNone);
  XMapRaised(XtDisplay(dialog), XtWindow(XtParent(dialog)));
        
}


/*
 * Load the entire ROI file to memory and popup a dialog
 * asking the user which ROIs to import
 */
static void read_roifile_cb(Widget widget, XtPointer client_data, XtPointer call_data) {
  XmString		string,string2;
  char                  *roifile;
  XmFileSelectionBoxCallbackStruct *cbs =
                     (XmFileSelectionBoxCallbackStruct *)call_data;
  Widget                list_w, list_dialog, rowcol, toggle_b, toggle_b2;
  XmStringTable         str_list;
  ROI_list		*roilist;
  RoiList		*rois;
  char                  tmp[256];
  int                   i=0,val;
  int                   frame, plane;
  Arg                   args[6];  

  if(!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &roifile))
    return;
  if(!roifile) return;
  roilist=(ROI_list*)malloc(sizeof(ROI_list));
  memset(roilist,0,sizeof(ROI_list));
  printf("%s\n", roifile);
  val=roi_read(roifile, roilist);
  if(val) {
    fprintf(stderr,"read_roifile_cb(): roi_read(\"%s\",roilist) returned %d\n",roifile,val);
    error_dialog("Error occured while reading ROI file !");
    return;
  }

  str_list = (XmStringTable) XtMalloc (roilist->nr * sizeof (XmString));
  rois=roilist->rois;
  while(rois) {
     frame = rois->roi->matnum&0xFFF;
     plane = (rois->roi->matnum>>16)&0xFF;
  
     sprintf(tmp, "%s\t %d  %d", rois->roi->roiname, frame, plane);
     str_list[i] = XmStringCreateLocalized (tmp);
     i++;
     rois=rois->next;
  }

  /* Create dialog to show rois in selected file and 
   * to ask which rois user want to load in.
   */
  string=XmStringCreateLocalized("Load to:");
  string2=XmStringCreateLocalized("Select ROIs to load");
  XtSetArg(args[0],XmNselectionLabelString,string);
  XtSetArg(args[1],XmNdialogTitle,string2);
  list_dialog = XmCreatePromptDialog (widget, "roi", args, 2);
  XmStringFree(string);
  XmStringFree(string2);
  XtAddCallback(list_dialog, XmNokCallback, read_roi_cb, roilist);
  XtAddCallback(list_dialog, XmNcancelCallback, unmanage_cb, NULL);

  /* Create rowcolumn into dialog and toggle button for select all rois.
   */
  i=0;
  XtSetArg (args[i], XmNorientation, XmVERTICAL); i++;
  rowcol = XmCreateRowColumn(list_dialog, "rowcolumn", args, i);

  /*first in column toggle button for selecting all */
  toggle_b=XmCreateToggleButton (rowcol, "Select All", NULL, 0);
  

  /* second: Create the ScrolledList of all ROIs in file.*/
   i = 0;
   XtSetArg (args[i], XmNvisibleItemCount, 5); i++;
   XtSetArg (args[i], XmNitemCount, roilist->nr); i++;
   XtSetArg (args[i], XmNitems, str_list);     i++;
   XtSetArg (args[i], XmNscrollBarDisplayPolicy, XmSTATIC);     i++;
   XtSetArg (args[i], XmNselectionPolicy, XmMULTIPLE_SELECT); i++;
   list_w = XmCreateScrolledList (rowcol, "selectedrois", args, i);
   XtAddCallback (toggle_b, XmNvalueChangedCallback, 
                 selectall_cb, (XtPointer)list_w);


   /* 3. toggle button for loading selected ROIs to all frames */
   string=XmStringCreateLocalized("Load to all frames");
   XtSetArg(args[0],XmNlabelString,string);
   toggle_b2=XmCreateToggleButton (rowcol, "load_to_all_frames", args, 1);
   XmStringFree(string);

   for (i = 0;i<roilist->nr; i++)
     XmStringFree (str_list[i]);
   XtFree ((char *)str_list);
   
   /* Unmanage the parent */
   XtUnmanageChild(widget);
   /* Manage scrolled list  */
   XtManageChild (toggle_b);
   XtManageChild (toggle_b2);
   XtManageChild (rowcol);
   XtManageChild (list_w);
   XtManageChild (list_dialog);

   XtFree(roifile);

}

