#ifndef ROI_DIALOG_H
#define ROI_DIALOG_H

/* Popup a dialog asking the name of the ROI. If OK is pressed, the ROI is saved
   to global roi_list
*/
extern void name_roi_dialog(char *message,ROI *roi);

/* Popup a dialog to rename the ROI pointed by *roi
*/
extern void rename_dialog(char *message, ROI *roi);

/* Popup a file selection dialog for saving ROIs */
extern void roi_save_dialog();

/* Check if a ROI file exists and save data */
extern void check_roifile(Widget widget, XtPointer client_data, XtPointer call_data);

/* Pop up a file open dialog to get the filename for the ROI file to load
*/
extern void roi_read_dialog();

/* Confirm ROI to Trace ROI conversion */
extern void roi_convert_dialog(ROI *roi);

#endif

