#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <Xm/Xm.h>
#include <ecat63.h>	/* mat_numcod() */
#include "petimage.h"
#include "main.h"
#include "roi_dialog.h"
#include "zoom_images.h"
#include "roiutils.h"
#include "deviation.h"

/* ROIs need to be offset a bit because of the petimage widget's border */
#define ROI_OFFSET 1

typedef struct _RoiPointList {
  int x,y;
  struct _RoiPointList *next;
  struct _RoiPointList *prev;
} RoiPointList;

static void finalize_roi(Widget w,ROI *roi);
static void finish_trace_roi(ROI *roi,RoiPointList *points,int count,int offset);

void traceroi_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  static RoiPointList *points=NULL;
  ROI *roi=(ROI*)client_data;
  XButtonEvent *event=call_data;
  if(event->button==Button1) { /* Add new point */
    RoiPointList *newpoint;
    newpoint=(RoiPointList*)malloc(sizeof(RoiPointList));
    newpoint->next=NULL;
    newpoint->prev=points;
    if(newpoint->prev) newpoint->prev->next=newpoint;
    newpoint->x=event->x;
    newpoint->y=event->y;
    points=newpoint;
    PetimageSetRoiDrawPoint((PetimageWidget)w,event->x,event->y);
  } else { /* End drawing */
    RoiPointList *next;
    int c=1;
    if(!points) return;
    while(points->prev) {points=points->prev; c++;}
    if(c>2) {
      finish_trace_roi(roi,points,c,ROI_OFFSET);
      finalize_roi(w,roi);
      name_roi_dialog("Give a name for ROI:",roi);
      while(points) {
        next=points->next;
        free(points);
        points=next;
      }
    } else free(roi);
    PetimageEndRoiDraw((PetimageWidget)w);
    set_ROI_drawmode(NULL,-1);
  }
}

static void finish_trace_roi(ROI *roi,RoiPointList *points,int count,int offset) {
  int i=0,fx,fy;
  roi->point_nr=count;
  roi->x=(int*)malloc(sizeof(int)*count);
  roi->y=(int*)malloc(sizeof(int)*count);
  fx=points->x;
  fy=points->y;
  roi->pos_x=fx;
  roi->pos_y=fy;

  while(points) {
    roi->x[i]=points->x-fx-offset;
    roi->y[i]=points->y-fy-offset;
    i++;
    points=points->next;
  }
}



void rectangleroi_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  static RoiPointList *point=NULL;
  ROI *roi=(ROI*)client_data;
  XButtonEvent *event=(XButtonEvent*)call_data;
  if(!point) { /* Add first point */
    point=(RoiPointList*)malloc(sizeof(RoiPointList));
    point->prev=NULL;
    point->next=NULL;
    point->x=event->x+ROI_OFFSET;
    point->y=event->y+ROI_OFFSET;
    PetimageSetRoiDrawPoint((PetimageWidget)w,point->x,point->y);
    PetimageSetRoiDrawPoint((PetimageWidget)w,point->x,point->y);
  } else { /* End */
    PetimageEndRoiDraw((PetimageWidget)w);
    if(event->button!=Button3) {
      roi->pos_x=(point->x<event->x?point->x:event->x)-ROI_OFFSET;
      roi->pos_y=(point->y<event->y?point->y:event->y)-ROI_OFFSET;
      roi->w=abs(point->x-event->x);
      roi->h=abs(point->y-event->y);
      roi->x=NULL;
      roi->y=NULL;
      roi->point_nr=0;
      finalize_roi(w,roi);
      name_roi_dialog("Give a name for ROI:",roi);
    } else {
      PetimageUpdate(get_zoom_image()->widget[0]);
      PetimageUpdate(get_zoom_image()->widget[1]);
      free(roi);
    }
    free(point);
    point=NULL;
    set_ROI_drawmode(NULL,-1);
  }
}

void circleroi_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  static RoiPointList *point=NULL;
  ROI *roi=(ROI*)client_data;
  XButtonEvent *event=(XButtonEvent*)call_data;
  if(!point) { /* Add center point */
    point=(RoiPointList*)malloc(sizeof(RoiPointList));
    point->prev=NULL;
    point->next=NULL;
    point->x=event->x;
    point->y=event->y;
    PetimageSetRoiDrawPoint((PetimageWidget)w,point->x,point->y);
    PetimageSetRoiDrawPoint((PetimageWidget)w,point->x,point->y);
  } else { /* Finish */
    PetimageEndRoiDraw((PetimageWidget)w);
    if(event->button!=Button3) {
      roi->w=hypot(point->x-event->x,point->y-event->y);
      roi->pos_x=point->x-ROI_OFFSET;
      roi->pos_y=point->y-ROI_OFFSET;
      roi->h=roi->w;
      roi->x=NULL;
      roi->y=NULL;
      roi->point_nr=0;
      finalize_roi(w,roi);
      name_roi_dialog("Give a name for ROI:",roi);
    } else {
      PetimageUpdate(get_zoom_image()->widget[0]);
      PetimageUpdate(get_zoom_image()->widget[1]);
      free(roi);
    }
    free(point);
    point=NULL;
    set_ROI_drawmode(NULL,-1);
  }
}

void ellipseroi_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  static RoiPointList *point=NULL;
  ROI *roi=(ROI*)client_data;
  XButtonEvent *event=(XButtonEvent*)call_data;
  if(!point) { /* Add center point */
    point=(RoiPointList*)malloc(sizeof(RoiPointList));
    point->prev=NULL;
    point->next=NULL;
    point->x=event->x;
    point->y=event->y;
    PetimageSetRoiDrawPoint((PetimageWidget)w,point->x,point->y);
    PetimageSetRoiDrawPoint((PetimageWidget)w,point->x,point->y);
  } else { /* Finish */
    PetimageEndRoiDraw((PetimageWidget)w);
    if(event->button!=Button3) {
      roi->w=abs(point->x-event->x);
      roi->h=abs(point->y-event->y);
      roi->pos_x=point->x-ROI_OFFSET;
      roi->pos_y=point->y-ROI_OFFSET;
      roi->x=NULL;
      roi->y=NULL;
      roi->point_nr=0;
      finalize_roi(w,roi);
      name_roi_dialog("Give a name for ROI:",roi);
    } else {
      PetimageUpdate(get_zoom_image()->widget[0]);
      PetimageUpdate(get_zoom_image()->widget[1]);
      free(roi);
    }
    free(point);
    point=NULL;
    set_ROI_drawmode(NULL,-1);
  }
}

/* Finalize the ROI (set frame/plane numbers, calculate deviation, etc...) */
static void finalize_roi(Widget w,ROI *roi) {
  roi_userdata *userdata=(roi_userdata*)roi->userdata;
  int mystudy,frame[2],plane[2];
  /* Get the study number where this roi was created */
  XtVaGetValues(w,petimageNstudy,&mystudy,NULL);
  /* Set reconstruction zoom */
  roi->recon_zoom=studies[mystudy].imagepack.zoom;
  /* Set frame/plane numbers */
  XtVaGetValues(w,petimageNstudy,&mystudy,NULL);
  XtVaGetValues((Widget)get_zoom_image()->widget[0],petimageNframe,&frame[0],petimageNplane,&plane[0],NULL);
  XtVaGetValues((Widget)get_zoom_image()->widget[1],petimageNframe,&frame[1],petimageNplane,&plane[1],NULL);
  roi->matnum=mat_numcod(frame[mystudy], plane[mystudy], 1, 0, 0);
  if(frame[1]>=0 && plane[1]>=0) {
    if(frame[0]!=frame[1] || plane[0]!=plane[1]) { /* Looks like the planes/frames differ, we need to tell this in roi userdata */
      userdata->extra_study=1-mystudy;
      userdata->extra_matnum=mat_numcod(frame[userdata->extra_study], plane[userdata->extra_study], 1, 0, 0);
    }
  }
  /* Calculate deviation */
  calc_dev(&studies[0].imagepack,roi->matnum, roi, &userdata->mean, &userdata->dev);
}

/* Convert a ROI to Trace ROI */
void convertroi_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  ROI *roi=(ROI*)client_data;
  switch(roi->type) {
    case ROI_RECTANGULAR:
      roi_compute_rect(roi);
      break;
    case ROI_CIRCULAR:
      roi_compute_circle(roi);
      break;
    case ROI_ELLIPSE:
      roi_compute_ellipse(roi);
      break;
    case ROI_TRACE:
      fprintf(stderr,"convertroi_cb(): ROI \"%s\" is already a trace ROI !\n",roi->roiname);
      return;
    default:
      fprintf(stderr,"convertroi_cb(): ROI \"%s\" has unknown type '%d' !\n",roi->roiname,roi->type);
      return;
  }
  roi->type=ROI_TRACE;
}

