#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "main.h"
#include <ecat63.h>
#include "images.h"
#include "roiutils.h"
#include "deviation.h"
#include "message_dialog.h"

/* Put a ROI to ROI list. If no userdata is attached, it is created. */
ROI *put_roi_to_list(ROI *roi, ROI_list *roi_list)
{
  ROI *newroi;
  RoiList *newentry,*list=roi_list->rois;
  roi_userdata *userdata;
  newroi=(ROI*)malloc(sizeof(ROI));
  newentry=(RoiList*)malloc(sizeof(RoiList));
  if(list) {
    while(list->next) list=list->next;
    list->next=newentry;
  } else roi_list->rois=newentry;
  newentry->prev=list;
  newentry->next=NULL;
  newentry->roi=newroi;
  memcpy(newroi,roi,sizeof(ROI));
  if(roi->x) {
    newroi->x=(int*)malloc(sizeof(int)*newroi->point_nr);
    memcpy(newroi->x,roi->x,sizeof(int)*newroi->point_nr);
  }
  if(roi->y) {
    newroi->y=(int*)malloc(sizeof(int)*newroi->point_nr);
    memcpy(newroi->y,roi->y,sizeof(int)*newroi->point_nr);
  }
  roi_list->nr++;
  /* If the userdata is not attached, attach one now */
  if(newroi->userdata==NULL) {
    userdata=(roi_userdata*)malloc(sizeof(roi_userdata));
    memset(userdata,0,sizeof(roi_userdata));
    userdata->extra_study=-1;
    newroi->userdata=userdata;
    /* Calculate CoV inside of ROI */
    calc_dev(&studies[0].imagepack,roi->matnum, roi, &userdata->mean, &userdata->dev);
  }
  return newroi;
}

/* Get a ROI from ROI list and store a copy of it into *roi */
int get_roi_from_list(ROI *roi, ROI_list *roi_list, int i) {
  RoiList *list=roi_list->rois;
  int pos;
  for(pos=0;pos<i;pos++)
    list=list->next;
  memcpy(roi,list->roi,sizeof(ROI));
  if(roi->x) {
    roi->x=(int*)malloc(sizeof(int)*roi->point_nr);
    memcpy(roi->x,list->roi->x,sizeof(int)*roi->point_nr);
  }
  if(roi->y) {
    roi->y=(int*)malloc(sizeof(int)*roi->point_nr);
    memcpy(roi->y,list->roi->y,sizeof(int)*roi->point_nr);
  }

  return 0;
}

/* Fix the ROI pairings when displaying two-studies. */
/* This is done eg. when loading ROIs from a file.   */
void repair_rois(ROI_list *roi_list) {
  int frame,plane,frame2,plane2;
  RoiList *list=roi_list->rois;
  YaIT_Image *image;
  int studyN;
  studyN=panels.save_roi_studyn;
  while(list) {
    ROI *roi=list->roi;
    roi_userdata *userdata=(roi_userdata*)roi->userdata;
    if(!userdata) {	/* All ROIs should have userdata... */
      fprintf(stderr,"repair_rois(): ROI \"%s\" has no userdata !\n",roi->roiname);
      list=list->next;
      continue;
    }
    /* First, clear out the old pairings */
    if(userdata->extra_study==studyN)
      roi->matnum=userdata->extra_matnum;
    userdata->extra_study=-1;
    /* Then make the new ones */
    frame=(roi->matnum&0xFFF);
    plane=((roi->matnum>>16)&0xFF);
    image=find_image(studyN,frame-1,plane-1);
    if(!image) {
      fprintf(stderr,"repair_rois(): Error ! Could not find image from frame %d, plane %d !\n",frame,plane);
      list=list->next;
      continue;
    }
    image=get_2nd_zoom_image(image);
    if(image) {
      XtVaGetValues((Widget)image->widget,petimageNframe,&frame2,petimageNplane,&plane2,NULL);
      if(frame!=frame2 || plane!=plane2) { /* Neighbours frame/plane numbers are different */
        userdata->extra_study=!studyN;
	userdata->extra_matnum=mat_numcod(frame2, plane2, 1, 0, 0);
      }
    }
    list=list->next;
  }
}

