#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include <roi.h>
#include "roiutils.h"

#include "main.h"

/* Check if the point (x,y) is inside a ROI */
char hit_roi(ROI *roi,int x,int y) {
  switch(roi->type) {
    case ROI_TRACE: {		/* Trace ROI */
      int r,c=0,n;
      x-=roi->pos_x;
      y-=roi->pos_y;
      for(r=0;r<roi->point_nr;r++) {
        if(r<roi->point_nr-1) n=r+1; else n=0;
	if((roi->y[r]>y && roi->y[n]<=y) || (roi->y[r]<y && roi->y[n]>=y)) {
	  if(roi->x[r]>=x && roi->x[n]>=x) {
	    c++;
	  } else if(roi->x[r]>=x || roi->x[n]>=x) {
	    int top,left,bottom,right;
	    double a,a1;
	    if(roi->x[r]<roi->x[n]) {
	      left=roi->x[r];
	      right=roi->x[n];
	    } else {
	      left=roi->x[r];
	      right=roi->x[n];
	    }
	    if(roi->y[r]<roi->y[n]) {
	      top=roi->y[r];
	      bottom=roi->y[n];
	    } else {
	      top=roi->y[r];
	      bottom=roi->y[n];
	    }
	    a=atan2(right-x,bottom-y);
	    a1=atan2(right-left,bottom-top);
	    if((roi->y[r]<=roi->y[n] && a>a1) || (roi->y[r]>roi->y[n] && a<a1)) {
	      c++;
	    }
	  }
	}
      }
      if(c%2) return 1;
    } break;
    case ROI_RECTANGULAR:	/* Rectangle ROI */
      if(x>=roi->pos_x && x<=roi->pos_x+roi->w)
        if(y>=roi->pos_y && y<=roi->pos_y+roi->h)
	  return 1;
      break;
    case ROI_CIRCULAR: {	/* Circle ROI */
      if(hypot(roi->pos_x-x,roi->pos_y-y)<=roi->w) return 1;
    } break;
    case ROI_ELLIPSE: {		/* Ellipse ROI */
      x=roi->pos_x-x;
      y=roi->pos_y-y;
      if(((x*x)/(roi->w*roi->w))+((y*y)/(roi->h*roi->h))<1.0) return 1;
    } break;
  }
  /* Guess it wasn't in it */
  return 0;
}

/* Get the area of the ROI in pixels */
int roi_area(ROI *roi) {
  switch(roi->type) {
    case ROI_TRACE: {
        int i,j;
        double area=0;
        for(i=0;i<roi->point_nr;i++) {
          j=(i+1)%roi->point_nr;
	      area+=roi->x[i]*roi->y[j];
          area-=roi->y[i]*roi->x[j];
        }
        area/=2.0;
        return area<0?-area:area;
      }
    case ROI_RECTANGULAR:
      return roi->w*roi->h;
    case ROI_CIRCULAR:
      return M_PI*(roi->w)*(roi->w);
    case ROI_ELLIPSE:
     return (M_PI*(roi->w*2)*(roi->h*2))/4.0;
  }
  return 1;
}

/* Returns an XYBitmap format XImage that displays the     */
/* actual pixels used by the ROI. width and height are the */
/* dimensions of the unzoomed image.			   */
XImage *lego_roi(Display *d,Visual *v,ROI *roi,int width,int height,int zoom) {
  XImage *image;
  char **onoff;
  char *data,*dataptr;
  int i,j,bit,zx,zy;
  char lsbfirst=(BitmapBitOrder(d)==LSBFirst);
  int owidth,oheight;

  if(panels.smoothroi) {
      owidth=width*zoom;
      oheight=height*zoom;
  } else {
      owidth=width;
      oheight=height;
  }

  /* Allocate memory for onoff matrix */
  onoff=malloc(sizeof(char*)*owidth);
  if(onoff==NULL) {
    fprintf(stderr,"lego_roi(d,v,roi,%d,%d,%d): Out of memory !\n",width,height,zoom);
    return NULL;
  }
  for(j=0;j<oheight;j++) {
    onoff[j]=malloc(oheight);
    if(onoff[j]==NULL) {
      fprintf(stderr,"lego_roi(d,v,roi,%d,%d,%d): Out of memory !\n",width,height,zoom);
      return NULL;
    }
  }
  data=calloc(width*height*zoom*zoom/8,1);
  /* Compute onoff matrix */
  roi_onoff(roi, owidth, oheight,panels.smoothroi?zoom:1,onoff); 
  /* Convert the data to suitable format */
  if(panels.smoothroi) {
      bit=0;
      dataptr=data;
      for(j=0;j<oheight;j++) {
          for(i=0;i<owidth;i++) {
              if(onoff[i][j]) *dataptr |= 1<<(lsbfirst?bit:7-bit);
              if(bit==7) {
                  bit=0;
                  dataptr++;
              } else bit++;
          }
      }
  } else {
      /* Convert and scale */
      bit=0;
      dataptr=data;
      for(j=0;j<height;j++) {
        for(zy=0;zy<zoom;zy++) {
          for(i=0;i<width;i++) {
            for(zx=0;zx<zoom;zx++) {
              if(onoff[i][j]) *dataptr |= 1<<(lsbfirst?bit:7-bit);
              if(bit==7) {
                bit=0;
                dataptr++;
              } else bit++;
            }
          }
        }
      }
  }
  /* Create XImage */
  image=XCreateImage(d,v,1,XYBitmap,0,data,width*zoom,height*zoom,8,0);
  /* Cleanup */
  for(j=0;j<owidth;j++)
    free(onoff[j]);
  free(onoff);
  return image;
}

