#ifndef ROI_UTILS_H
#define ROI_UTILS_H

/* Some useful functions for ROI handling. Used mainly by petimage widget */

/* Some special ROI modes */
#define ROI_MOVE        90
#define ROI_RESIZE      91
#define ROI_ROTATE      92
#define ROI_DOUBLE	93
#define ROI_PROFILE	94

/* ROI userdata structure */
typedef struct {
  float mean;
  float dev;
  int extra_study;
  int extra_matnum;
} roi_userdata;

/* Some utility functions for ROIs */

/* Check if a point (x,y) is inside the given ROI	*/
/* Supports trace,rectangle,circle and ellipse ROIs	*/
extern char hit_roi(ROI *roi,int x,int y);

/* Get the area of the ROI in pixels */
/* Supports trace,rectangle,circle and ellipse ROIs	*/
extern int roi_area(ROI *roi);

/* Returns an XYBitmap format XImage that displays the  */
/* actual pixels used by the ROI */
extern XImage *lego_roi(Display *d,Visual *v,ROI *roi,int width,int height,int zoom);

#endif

