#include <stdio.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include "main.h"
#include "roiutils.h"
#include "deviation.h"
#include "message_dialog.h"
#include "move_roi.h"
#include "cursor.h"
#include "zoom_images.h"

void rotate_roi_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  XButtonEvent *event=call_data;
  static int x=-1,y;
  ROI *roi;
  if(x<0) {
    XtVaGetValues(w,petimageNselectedRoi,&roi,NULL);
    if(roi==NULL) {
      set_ROI_drawmode(NULL,-1);
      message_dialog("Please select a ROI first","Rotate ROI");
      return;
    }
    if(roi->type!=ROI_TRACE) {
      set_ROI_drawmode(NULL,-1);
      message_dialog("Incorrect ROI type ! Only trace ROI is supported !","Rotate ROI");
      return;
    }
    PetimageHighlightRoi((PetimageWidget)w,roi,ROI_ROTATE);
    x=event->x;
    y=event->y;
    my_SetMoveCursor(w);
  } else {
    if(event->button!=Button3) {
      int r,oX,oY,minx=10000,miny=10000,maxx=-10000,maxy=-10000,z;
      double a,b,c,zoom;
      XtVaGetValues(w,petimageNselectedRoi,&roi,petimageNzoom,&z,NULL);
      zoom=roi->zoom/(double)z;
      /* Get boundaries */
      for(r=0;r<roi->point_nr;r++) {
        if(roi->x[r]<minx) minx=roi->x[r];
        if(roi->x[r]>maxx) maxx=roi->x[r];
        if(roi->y[r]<miny) miny=roi->y[r];
        if(roi->y[r]>maxy) maxy=roi->y[r];
      }
      /* Calculate origo */
      oX=minx+(maxx-minx)/2;
      oY=miny+(maxy-miny)/2;
      /* Calculate angle */
      a=atan2(oX+roi->pos_x-(event->x/zoom),oY+roi->pos_y-(event->y/zoom))-atan2(oX+roi->pos_x-(x/zoom),oY+roi->pos_y-(y/zoom));
      /* Rotate around that origo */
      for(r=0;r<roi->point_nr;r++) {
        b=atan2(roi->x[r]-oX,roi->y[r]-oY);
        b+=a; c=hypot(roi->x[r]-oX,roi->y[r]-oY);
        roi->x[r]=sin(b)*c+oX;
        roi->y[r]=cos(b)*c+oY;
      }
      /* Calculate CoV inside of ROI
      */
      calc_dev(&studies[0].imagepack,roi->matnum, roi, &((roi_userdata*)roi->userdata)->mean, &((roi_userdata*)roi->userdata)->dev);
      XtVaSetValues(w,petimageNrequestRoi,roi,NULL);
    }
    /* Finish up */
    x=-1;
    y=-1;
    PetimageEndRoiDraw((PetimageWidget)w);
    set_ROI_drawmode(NULL,-1);
    PetimageUpdate(get_zoom_image()->widget[0]);
    PetimageUpdate(get_zoom_image()->widget[1]);
  }
}

