#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/List.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/SelectioB.h>
#include <ecat63.h>
#include "main.h"
#include "file_cb.h"
#include "list_cb.h"
#include "message_dialog.h"
#include "roi_dialog.h"
#include "util.h"

void scroll_list_rois(void)
{
  Widget                list_widget, list_dialog, rowcol, toggle_b;
  XmString              rename, delete, close,title;
  XmStringTable         str_list;
  Arg                   args[5];
  char                  tmp[256];
  int                   i,n;
  int                   frame, plane;
  RoiList		*list;

  printf("list selected\n");

  if(roi_list.nr==0){
        message_dialog("There are no ROIs to list !","Unable to list ROIs"); 
        return;
  }

  rename = XmStringCreateLocalized("Rename");
  delete = XmStringCreateLocalized("Delete");
  close  = XmStringCreateLocalized("Close");
  title =  XmStringCreateLocalized("ROIs");
  i = 0;
  XtSetArg (args[i], XmNokLabelString, rename); i++;
  XtSetArg (args[i], XmNcancelLabelString, delete); i++;
  XtSetArg (args[i], XmNhelpLabelString, close); i++;
  XtSetArg (args[i], XmNdialogTitle, title); i++;
  list_dialog = XmCreatePromptDialog (toplevel, "roi_list", args, i);
  XtAddCallback(list_dialog, XmNokCallback, list_cb, NULL);
  XtAddCallback(list_dialog, XmNcancelCallback, list_cb, NULL); 
  XtAddCallback(list_dialog, XmNhelpCallback, list_cb, NULL);
  XmStringFree(rename);
  XmStringFree(close);
  XmStringFree(delete);
  XmStringFree(title);
  //XtUnmanageChild (XtNameToWidget (list_dialog, "TextField"));

  n=roi_list.nr;


  /* Create rowcolumn into dialog and toggle button for select all rois.
   */
  i=0;
  XtSetArg (args[i], XmNorientation, XmVERTICAL); i++;
  rowcol = XmCreateRowColumn(list_dialog, "rowcolumn", args, i);

  toggle_b=XmCreateToggleButton (rowcol, "Select All", NULL, 0);
 

  str_list = (XmStringTable) XtMalloc (n * sizeof (XmString));
  list=roi_list.rois;
  i=0;
  while(list) {
    if(list->roi->status!=-1){
        frame = (list->roi->matnum&0xFFF);
        plane = ((list->roi->matnum>>16)&0xFF);
  
        sprintf(tmp, "%s\t %d  %d", list->roi->roiname, frame, plane);
        str_list[i] = XmStringCreateLocalized (tmp);
	i++;
    }
    list=list->next;
  }

  // Create the ScrolledList 
    i = 0;
    XtSetArg (args[i], XmNvisibleItemCount, 5); i++;
    XtSetArg (args[i], XmNitemCount, n);        i++;
    XtSetArg (args[i], XmNitems, str_list);     i++;
    XtSetArg (args[i], XmNscrollBarDisplayPolicy, XmSTATIC);     i++;
    XtSetArg (args[i], XmNselectionPolicy, XmMULTIPLE_SELECT); i++;
    list_widget = XmCreateScrolledList (rowcol, "selectedrois", args, i);
 
    XtAddCallback (toggle_b, XmNvalueChangedCallback, 
                   selectall_cb, (XtPointer)list_widget);
    

    /*   for (i = 0; str_list[i]; i++)
         XmStringFree (str_list[i]);
    XtFree((char *)str_list);
    */
   // Manage scrolled list 
    XtManageChild (toggle_b);
    XtManageChild (rowcol);
    XtManageChild (list_widget);
    XtManageChild (list_dialog);

}

/* OK was pressed from Save ROI dialog */
/* Create a dialog box to ask the user which ROIs to save */
void select_save_roi(Widget widget, XtPointer client_data, XtPointer call_data)
{
  Widget                list_w, list_dialog, rowcol, toggle_b;
  XmStringTable         str_list;
  Arg                   args[5];
  char                  tmp[256], *filename_d;
  int                   i,n;
  int                   frame, plane;
  RoiList		*list;
  XmFileSelectionBoxCallbackStruct *cbs =
     (XmFileSelectionBoxCallbackStruct *)call_data;

  if(!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &filename_d))
      return;

  printf("roifile: %s\n", filename_d);
  // strcpy(roifile, filename_d);
  //XtFree(filename_d);

  list_dialog = XmCreatePromptDialog (toplevel, "list_dialog", NULL, 0);  

  n=roi_list.nr;
  /* Create rowcolumn into dialog and toggle button for select all rois.
   */
  i=0;
  XtSetArg (args[i], XmNorientation, XmVERTICAL); i++;
  rowcol = XmCreateRowColumn(list_dialog, "rowcolumn", args, i);

  toggle_b=XmCreateToggleButton (rowcol, "Select All", NULL, 0);
 
  str_list = (XmStringTable) XtMalloc (n * sizeof (XmString));
  list=roi_list.rois;
  i=0;
  while(list) {
    if(list->roi->status!=-1){
        frame = list->roi->matnum&0xFFF;
        plane = (list->roi->matnum>>16)&0xFF;
  
        sprintf(tmp, "%s\t %d  %d", list->roi->roiname, frame, plane);
        str_list[i] = XmStringCreateLocalized (tmp);
	i++;
    }
    list=list->next;
  }

   /* Create the ScrolledList */
   i = 0;
   XtSetArg (args[i], XmNvisibleItemCount, 5); i++;
   XtSetArg (args[i], XmNitemCount, n);        i++;
   XtSetArg (args[i], XmNitems, str_list);     i++;
   XtSetArg (args[i], XmNscrollBarDisplayPolicy, XmSTATIC);     i++;
   XtSetArg (args[i], XmNselectionPolicy, XmMULTIPLE_SELECT); i++;
   list_w = XmCreateScrolledList (rowcol, "selectedrois", args, i);
  
   XtAddCallback(list_dialog, XmNcancelCallback, unmanage_cb, NULL);
   XtAddCallback(list_dialog, XmNokCallback, 
                 check_roifile, (XtPointer)filename_d);
   XtAddCallback (toggle_b, XmNvalueChangedCallback, selectall_cb, (XtPointer)list_w);

   /*for (i = 0; str_list[i]; i++)
        XmStringFree (str_list[i]);
     XtFree((char *)str_list);
   */
   /* Manage scrolled list */
   XtManageChild (toggle_b);
   XtManageChild (rowcol);
   XtManageChild (list_w);
   XtManageChild (list_dialog);
   XtUnmanageChild(widget);


}

/* Select ROIs to be copied to another matrix/plane */
void select_copy_roi()
{
  Widget                list_w, list_dialog, rowcol, toggle_b ;
  XmString              matrix,title;
  XmStringTable		str_list;
  Arg                   args[5];
  char                  tmp[256];
  int                   i,n;
  int                   frame, plane;
  RoiList		*list;

  matrix = XmStringCreateLocalized("Copy to matrixes:");
  title =  XmStringCreateLocalized("Copy ROI");
  i=0;
  XtSetArg(args[i], XmNselectionLabelString, matrix); i++;
  XtSetArg(args[i], XmNdialogTitle, title); i++;
  list_dialog = XmCreatePromptDialog (toplevel, "list_dialog", args, i);
  XmStringFree(matrix);
  XmStringFree(title);

  n=roi_list.nr;

  /* Create rowcolumn into dialog and toggle button for select all rois.
   */
  i=0;
  XtSetArg (args[i], XmNorientation, XmVERTICAL); i++;
  rowcol = XmCreateRowColumn(list_dialog, "rowcolumn", args, i);

  toggle_b=XmCreateToggleButton (rowcol, "Select All", NULL, 0);

  str_list = (XmStringTable) XtMalloc (n * sizeof (XmString));
  list=roi_list.rois;
  i=0;
  while(list) {
    if(list->roi->status!=-1){
        frame = list->roi->matnum&0xFFF;
        plane = (list->roi->matnum>>16)&0xFF;
  
        sprintf(tmp, "%s\t %d  %d", list->roi->roiname, frame, plane);
        str_list[i] = XmStringCreateLocalized (tmp);
	i++;
    }
    list=list->next;
  }

   /* Create the ScrolledList */
   i = 0;
   XtSetArg (args[i], XmNvisibleItemCount, 5); i++;
   XtSetArg (args[i], XmNitemCount, n);        i++;
   XtSetArg (args[i], XmNitems, str_list);     i++;
   XtSetArg (args[i], XmNscrollBarDisplayPolicy, XmSTATIC);     i++;
   XtSetArg (args[i], XmNselectionPolicy, XmMULTIPLE_SELECT); i++;
   list_w = XmCreateScrolledList (rowcol, "selectedrois", args, i);
  
   XtAddCallback(list_dialog, XmNcancelCallback, unmanage_cb, NULL);
   XtAddCallback(list_dialog, XmNokCallback, copy_roi_cb, NULL);
 
   XtAddCallback (toggle_b, XmNvalueChangedCallback, 
                  selectall_cb, (XtPointer)list_w);


   /*   for (i = 0; str_list[i]; i++)
         XmStringFree (str_list[i]);
   XtFree((char *)str_list);
   */
   /* Manage scrolled list */
   XtManageChild (toggle_b);
   XtManageChild (rowcol);
   XtManageChild (list_w);
   XtManageChild (list_dialog);


}


void select_mirrorcopy_roi()
{
  Widget                list_w, list_dialog,dialog_form, end_w;
  XmString              matrix, ending,title;
  XmStringTable         str_list;
  Arg                   args[10];
  char                  tmp[256], end[64];
  int                   i,n;
  int                   frame, plane;
  RoiList		*list;

  matrix = XmStringCreateLocalized("Mirror copy to matrixes:");
  title = XmStringCreateLocalized("Mirror copy ROI");
  i=0;
  XtSetArg(args[i], XmNselectionLabelString, matrix); i++;
  XtSetArg(args[i], XmNdialogTitle,title); i++;
  list_dialog = XmCreatePromptDialog (toplevel, "list_dialog", args, i);
  XmStringFree(matrix);
  XmStringFree(title);
  dialog_form = XtVaCreateManagedWidget("main_window",
       xmFormWidgetClass, list_dialog,		  
       NULL);

  /* Create another text field to ask ending of roiname */
   ending = XmStringCreateLocalized("Ending for roinames:");
   i=0;
   XtSetArg (args[i], XmNleftOffset, 20); i++;
   XtSetArg (args[i], XmNleftAttachment, XmATTACH_FORM); i++;
   XtSetArg (args[i], XmNtopOffset, 20); i++;
   XtSetArg (args[i], XmNtopAttachment, XmATTACH_FORM); i++;
   XtSetArg (args[i], XmNlabelString, ending); i++;
   end_w=XmCreateTextField(dialog_form, "end", args, i);
   XmStringFree(ending);

   sprintf(end, "_mirror");
   XmTextFieldSetString(end_w, end);


  n=roi_list.nr;
  str_list = (XmStringTable) XtMalloc (n * sizeof (XmString));
  list=roi_list.rois;
  i=0;
  while(list) {
    if(list->roi->status!=-1){
      frame = list->roi->matnum&0xFFF;
      plane = (list->roi->matnum>>16)&0xFF;
  
      sprintf(tmp, "%s\t %d  %d", list->roi->roiname, frame, plane);
      str_list[i] = XmStringCreateLocalized (tmp);
      i++;
    }
    list=list->next;
  }

   /* Create the ScrolledList */
   i = 0;
   XtSetArg (args[i], XmNvisibleItemCount, 5); i++;
   XtSetArg (args[i], XmNitemCount, n);        i++;
   XtSetArg (args[i], XmNitems, str_list);     i++;
   XtSetArg (args[i], XmNscrollBarDisplayPolicy, XmSTATIC);     i++;
   XtSetArg (args[i], XmNselectionPolicy, XmMULTIPLE_SELECT); i++;
   XtSetArg (args[i], XmNleftOffset, 20); i++;
   XtSetArg (args[i], XmNleftAttachment, XmATTACH_FORM); i++;
   XtSetArg (args[i], XmNtopOffset, 50); i++;
   XtSetArg (args[i], XmNtopAttachment, XmATTACH_FORM); i++;


   list_w = XmCreateScrolledList (dialog_form, "selectedrois", args, i);
  
   XtAddCallback(list_dialog, XmNcancelCallback, unmanage_cb, NULL);
   XtAddCallback(list_dialog, XmNokCallback, mirrorcopy_roi_cb, end_w);


   /*  for (i = 0; str_list[i]; i++)
         XmStringFree (str_list[i]);
   XtFree((char *)str_list);
   */

   /* Manage scrolled list */
   XtManageChild (list_w);
   XtManageChild (end_w);
   XtManageChild (dialog_form);
   XtManageChild (list_dialog);

}

