#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include "colorslide.h"
#include "main.h"
#include "img.h"
#include "close_file.h"
#include "cursor.h"
#include "images.h"
#include "zoom_images.h"
#include "zoom_cb.h"
#include "colormap.h"

void spin_cb(Widget parent, XtPointer client_data, XtPointer call_data) { 
  XmStringTable values;
  char *tmpvalue;
  int pos,value;

  if(((XmSpinBoxCallbackStruct*)call_data)->reason!=XmCR_OK) return;
  my_SetWatchCursor(toplevel);
  XtVaGetValues(parent,XmNposition,&pos,NULL);
  XtVaGetValues(parent,XmNvalues,&values,NULL);
  tmpvalue=XmStringUnparse((XmString)(values[pos]),NULL,XmCHARSET_TEXT,XmCHARSET_TEXT,NULL,0,XmOUTPUT_ALL);
  value=atoi(tmpvalue)-1;
  XtFree(tmpvalue);
  if(parent==frame_spin){ /* Update frame number */
    zoom_matrix.frame=value;
    select_image_n(-1,zoom_matrix.frame,zoom_matrix.plane);	/* TODO: Somehow distinquish between study 1 and study 2 */
    if(zoom_matrix.zoom>0)
      zoom_current_image();
    //printf("frame = %d \n", zoom_matrix.frame);
  } else if(parent==plane_spin){  /* Update plane number */
    zoom_matrix.plane=value;
    select_image_n(-1,zoom_matrix.frame,zoom_matrix.plane);
    if(zoom_matrix.zoom>0) {
      zoom_current_image();
    }
    //printf("plane = %d \n", zoom_matrix.plane);
  } else {
    fprintf(stderr,"spin_cb(): Unknown widget ! (0x%dx)\n",(int)parent);
    return;
  }

  /* Write information to message_area */
  message_area_info();

  my_ResetCursor(toplevel);

}

