#include <stdio.h>
#include <Xm/DialogS.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>
#include "util.h"

Widget CreateActionArea (Widget parent, ActionAreaItem *actions, int num_actions) {
  Widget       action_area, widget;
  int          i;
  action_area = XmCreateForm (parent, "action_area", NULL, 0);
  XtVaSetValues (action_area,
                 XmNfractionBase, 3*num_actions - 1,
                 XmNleftOffset,   10,
                 XmNrightOffset,  10,
                 NULL);
  for (i = 0; i < num_actions; i++) {
      widget = XmCreatePushButton (action_area, actions[i].label,
                                   NULL, 0);
      XtVaSetValues (widget, 
                     XmNleftAttachment,
                         i? XmATTACH_POSITION: XmATTACH_FORM, 
                     XmNleftPosition,3*i,
                     XmNtopAttachment,XmATTACH_FORM,
                     XmNbottomAttachment,XmATTACH_FORM,
                     XmNrightAttachment, 
                         i != num_actions - 1 ?
                             XmATTACH_POSITION :
                                 XmATTACH_FORM,
                     XmNrightPosition, 3 * i + 2,
                     XmNshowAsDefault,i == 0, 
                     XmNdefaultButtonShadowThickness, 1, 
                     NULL); 
      if (actions[i].callback)
      XtAddCallback (widget, XmNactivateCallback, actions[i].callback, 
                     (XtPointer) actions[i].data);
      XtManageChild (widget);
      if (i == 0) {
          /* Set the action_area's default button to the first widget 
          ** created (or, make the index a parameter to the function
          ** or have it be part of the data structure). Also, set the
          ** pane window constraint for max and min heights so this
          ** particular pane in the PanedWindow is not resizable.
          */
          Dimension height, h;
          XtVaGetValues (action_area, XmNmarginHeight, &h, NULL);
          XtVaGetValues (widget, XmNheight, &height, NULL);
          height += 2 * h; 
          XtVaSetValues (action_area, 
                         XmNdefaultButton, widget, 
                         XmNpaneMaximum,   height, 
                         XmNpaneMinimum,   height,
                         NULL);
      }
  }
  XtManageChild (action_area);
  return action_area;
}

void unmanage_cb(Widget widget, XtPointer client_data, XtPointer call_data) {
  XtUnmanageChild(widget);
  if(client_data) XtDestroyWidget((Widget)client_data);
}

int find_table_entry(XmStringTable table,int count,char *entry) {
  XmString xmentry;
  int r;
  xmentry=XmStringCreateLocalized(entry);
  for(r=0;r<count;r++) {
    if(XmStringCompare(table[r],xmentry)==True) {
      XmStringFree(xmentry);
      return r;
    }
  }
  XmStringFree(xmentry);
  return -1;
}

