#ifndef YAIT_H
#define YAIT_H

#define DIM 256
#define WIDTH  900
#define HEIGHT 700
#define PROGRAM "YaIT 0.5.6 (c) Turku PET Centre 2002-2005"
#define YAIT_VER "0.5.6"

/* If you have a buggy motif implementation that has problems with */
/* managing mainwindow's children, #define BUGGY_MAINWINDOW and    */
/* YaIT will not use mainwindows				   */
#define BUGGY_MAINWINDOW
 
#include "intex.h"

#include "colortables.h"

typedef enum {ScaleAutomatic,ScaleFixed} ScaleType;

typedef struct {
  char filename[1024];
  IMG imagepack;
  INT_list framelist;
  INT_list planelist;
  ColorScale color;
  int c_lower,c_upper;
} Study;

typedef struct{  
  int       panel_maxnum; 
  ScaleType scale;
  int       no_neg_values;
  int	    show_matrix_rois;
  int       save_roi_studyn; /* Number of the study that's plane/frame numbers are used when saving the ROI */
  int       smoothroi;
} panel_type;

typedef struct{
  int            frame, plane, gate, zoom;
  int            interpolation;
}zoom_spanel;

/* Some useful macros */
#define MIN(a,b) ((a<b)?a:b)
#define MAX(a,b) ((a>b)?a:b)

#endif
