#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/TextF.h>
#include "main.h"
#include "cursor.h"
#include "zoom_images.h"
#include "message_dialog.h"
#include "zoom_cb.h"

void zoom_cb(Widget w, XtPointer client_data, XtPointer call_data) {
  if(strlen(studies[0].filename)<4) return;

  if((int)client_data<0 || (int)client_data>7) {
    fprintf(stderr,"zoom_cb(): Unknown client_data '%d' !\n",(int)client_data);
    return;
  }
  if((int)client_data==0) {
    if(zoom_matrix.zoom>0 && strlen(studies[0].filename))
      zoom_stop(1);
  } else {
    if((int)client_data<7)
      zoom_matrix.zoom=((int)client_data);
    else
      zoom_matrix.zoom=10;

    zoom_current_image();
  }

  /* Write information to message_area */
  message_area_info();
}

void zoom_current_image(void) {
  int frame1,frame2=-1,plane1,plane2=-1;
  YaIT_Image *selected,*neighbour;

  my_SetWatchCursor(toplevel);
  selected=get_selected_image();
  XtVaGetValues((Widget)selected->widget,petimageNframe,&frame1,petimageNplane,&plane1,NULL);
  neighbour=get_2nd_zoom_image(selected);
  if(neighbour) {
    if(selected->studyN==0) {
      XtVaGetValues((Widget)neighbour->widget,petimageNframe,&frame2,petimageNplane,&plane2,NULL);
    } else {
      frame2=frame1;
      plane2=plane1;
      XtVaGetValues((Widget)neighbour->widget,petimageNframe,&frame1,petimageNplane,&plane1,NULL);
    }
  } else if(selected->studyN==1) {
    my_ResetCursor(toplevel);
    message_dialog("2nd study image has no pair!","Cannot zoom");
    return;
  }
  /* Show zoomed matrix at display_area */
  set_zoom_image(frame1,plane1,frame2,plane2,zoom_matrix.zoom,zoom_matrix.interpolation);

  my_ResetCursor(toplevel);
}

