#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <X11/keysym.h>
#include <Xm/TextF.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <Xm/Form.h>

#include "main.h"
#include "colormap.h"
#include "zoom_images.h"
#include "message_dialog.h"
#include "interpolation_cb.h"
#include "roi_functions.h"
#include "roiutils.h"
#include "cursor.h"
#include "move_roi.h"
#include "double_roi.h"
#include "rotate_roi.h"
#include "profile.h"

/* Internally used globals */
static ZoomImage *zoom_image=NULL;
static Widget zoom_image_manager;

static void pixel_resize(int frame,float ***src, float *targ,float *min,float *max,int width,int height,int zoom);
static void smooth_resize(int frame,float ***src, float *targ,float *min,float *max,int width,int height,int zoom);
static void roi_select_cb(Widget w,XtPointer client_data, XtPointer call_data);
static void roi_command_cb(Widget w,XtPointer client_data,XtPointer call_data);
static void coordinate_cb(Widget w,XtPointer client_data,XtPointer call_data);

/* Initialize zoom */
void init_zoom_images(void) {
  zoom_image_manager=XtVaCreateWidget("zoomed_image_manager",
  	xmRowColumnWidgetClass,
#ifdef BUGGY_MAINWINDOW
	display_area,
#else
	main_w,
#endif
#ifdef BUGGY_MAINWINDOW
/*
	XmNrightOffset, 0,
	XmNrightAttachment, XmATTACH_FORM,
	XmNleftOffset, 0,
	XmNleftAttachment, XmATTACH_FORM,
	XmNtopOffset, 70,
	XmNtopAttachment, XmATTACH_FORM,
	XmNbottomOffset, 20,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNresizePolicy, XmRESIZE_GROW,*/
#else
	XmNscrolledWindowChildType, XmWORK_AREA,
#endif
	XmNorientation,XmHORIZONTAL,
	XmNresizeWidth,True,
	XmNresizeHeight,True,
	XmNpacking,XmPACK_COLUMN,
	NULL);
	
  zoom_image=malloc(sizeof(ZoomImage));
  memset(zoom_image,0,sizeof(ZoomImage));
  zoom_image->widget[0]=(PetimageWidget)XtVaCreateWidget("zoomed_image",
  	petimageWidgetClass,zoom_image_manager,
  	XmNwidth,128,
	XmNheight,128,
	XmNtraversalOn,TRUE,
	XmNhighlightThickness,1,
	petimageNROI,&roi_list,
	petimageNroiColor,extra_palette[GREEN].pixel,
	petimageNselRoiColor,extra_palette[RED].pixel,
	petimageNstudy,0,
	NULL);
  zoom_image->widget[1]=(PetimageWidget)XtVaCreateWidget("zoomed_image2",
  	petimageWidgetClass,zoom_image_manager,
  	XmNwidth,128,
	XmNheight,128,
	XmNtraversalOn,True,
	XmNhighlightThickness,1,
	petimageNROI,&roi_list,
	petimageNroiColor,extra_palette[GREEN].pixel,
	petimageNselRoiColor,extra_palette[RED].pixel,
	petimageNstudy,1,
	NULL);
  XtAddCallback((Widget)zoom_image->widget[1],petimageNroiSelectedCb,roi_select_cb,NULL);
  XtAddCallback((Widget)zoom_image->widget[1],petimageNroiCommandCb,roi_command_cb,NULL);
  XtAddCallback((Widget)zoom_image->widget[1],petimageNhoverCb,coordinate_cb,NULL);
  XtAddCallback((Widget)zoom_image->widget[0],petimageNroiSelectedCb,roi_select_cb,NULL);
  XtAddCallback((Widget)zoom_image->widget[0],petimageNroiCommandCb,roi_command_cb,NULL);
  XtAddCallback((Widget)zoom_image->widget[0],petimageNhoverCb,coordinate_cb,NULL);
}

/* Return the zoom image widget */
PetimageWidget get_zoom_image_widget(void) {return zoom_image->widget[0];}

/* Return the zoom image */
ZoomImage *get_zoom_image(void) {return zoom_image;}

/* Select and zoom an image */
void set_zoom_image(int frame,int plane,int frame2,int plane2,int zoom,int interpolate) {
  if(frame<0 || plane<0) {
    fprintf(stderr,"set_zoom_image(%d,%d,%d,%d%d,%d): Error ! Plane/frame is negative !\n",frame,plane,frame2,plane2,zoom,interpolate);
    return;
  }
  XtVaSetValues((Widget)zoom_image->widget[0],petimageNframe,frame,petimageNplane,plane,NULL);
  XtVaSetValues((Widget)zoom_image->widget[1],petimageNframe,frame2,petimageNplane,plane2,NULL);
  
  XtUnmanageChild(matrix_widget);
  XtManageChild(zoom_image_manager);
#ifndef BUGGY_MAINWINDOW 
  XtVaSetValues(main_w,XmNworkWindow,zoom_image_manager,NULL);
#endif
  XtManageChild((Widget)zoom_image->widget[0]);
  if(frame2>=0 && plane2>=0)
    XtManageChild((Widget)zoom_image->widget[1]);
  else
    XtUnmanageChild((Widget)zoom_image->widget[1]);

  scale_image(zoom,interpolate);

  /* Enable ROI draw menu */
  XtSetSensitive(XtNameToWidget(toplevel,"*roimenu.button_0"),True);
  XtSetSensitive(XtNameToWidget(toplevel,"*roimenu.button_1"),True);
  PetimageUpdate(zoom_image->widget[0]);
  PetimageUpdate(zoom_image->widget[1]);
}

/* Restore image list */
void zoom_stop(int refresh) {
  set_ROI_drawmode(NULL,-1);
  XtUnmanageChild(zoom_image_manager);
  XtUnmanageChild((Widget)zoom_image->widget[0]);
  XtUnmanageChild((Widget)zoom_image->widget[1]);
  XtManageChild(matrix_widget);
#ifndef BUGGY_MAINWINDOW
  XtVaSetValues(main_w,XmNworkWindow,display_area,NULL);
#endif
  zoom_matrix.zoom=0;
  /* Set tick mark in zoom menu */
  XmToggleButtonSetState(XtNameToWidget(toplevel,"*.zoommenu.button_0"),XmSET,True);
  /* Disable ROI draw menu */
  XtSetSensitive(XtNameToWidget(toplevel,"*roimenu.button_0"),False);
  XtSetSensitive(XtNameToWidget(toplevel,"*roimenu.button_1"),False);
  /* Clear the point info box */
  XmTextFieldSetString(message_w2,"");
  if(refresh) {
    add_images(panels.scale,1); /* Update the image list */
    update_matrix_view(-1); 
  }
}

/* Zoom the image */
void scale_image(int zoom,int interpolate) {
  unsigned char *pdata;
  int xsize,ysize;
  Display *display;
  Visual *visual;
  float *data=NULL;
  float min,max;
  int k,studyN;
  int frame, plane,planei,framei;
  static Arg removeimage[]={{petimageNimage,(XtArgVal)NULL}};
#if 0  
  printf("scale_image(%d,%d);\n",zoom,interpolate);
#endif  
  display=XtDisplay(toplevel);
  visual=DefaultVisual(display,XDefaultScreen(display));

  for(studyN=0;studyN<2;studyN++) {
    /* Free old data (if any) */
    XtSetValues((Widget)zoom_image->widget[studyN],removeimage,1);
    if(zoom_image->image[studyN]) {
      XDestroyImage(zoom_image->image[studyN]);
      zoom_image->image[studyN]=NULL;
    }
    if(zoom_image->dimage[studyN]) {
      XDestroyImage(zoom_image->dimage[studyN]);
      zoom_image->dimage[studyN]=NULL;
    }
    /* Get the frame and plane number and convert/scale the data */
    XtVaGetValues((Widget)zoom_image->widget[studyN],petimageNframe,&frame,petimageNplane,&plane,NULL);
    if(frame<1 || plane<1) continue;
    frame--;
    plane--;
    if(find_frame_plane_index(&studies[studyN],frame,plane,&framei,&planei)) {
      printf("scale_image(%d,%d): Error ! Couldn't find frame %d,plane %d from study %d !\n",zoom,interpolate,frame,plane,studyN);
      fatal_error_dialog("Could not find requested image !");
    }
    xsize=studies[studyN].imagepack.dimx*zoom;
    ysize=studies[studyN].imagepack.dimy*zoom;

    /* Allocate memory for the raw data */
    data=malloc(sizeof(float)*xsize*ysize);
    if(data==NULL) {
      fprintf(stderr,"scale_image(%d,%d,%d): Can't allocate memory for data !\n",frame,plane,zoom);
      fatal_error_dialog("Memory is full !");
      return;
    }
    /* Get the image */
    min=10000.0; max=-10000.0;
    if(interpolate)
      smooth_resize(framei,studies[studyN].imagepack.m[planei],data,&min,&max,studies[studyN].imagepack.dimx,studies[studyN].imagepack.dimy,zoom);
    else
      pixel_resize(framei,studies[studyN].imagepack.m[planei],data,&min,&max,studies[studyN].imagepack.dimx,studies[studyN].imagepack.dimy,zoom);
    if(panels.scale==ScaleFixed)
      get_minmax(&studies[studyN],&min,&max);
    if(panels.no_neg_values) {
      for(k=0;k<xsize*ysize;k++)
        if(data[k]<0) data[k]=0;
      min=0;
      set_negative_values(0);
    } else {
      set_negative_values(min<0.0);
      printf("negative values: %d\n", min<0.0);
    }
    /* Scale the values to the range of the palette */
    pdata=malloc(xsize*ysize);
    for(k=0;k<xsize*ysize; k++) {
      double val;
      val=(data[k]-min)/(fabs(min)+fabs(max));
      pdata[k]=val*(PALETTE_COLORS-1);
    }
    free(data);
    /* Create XImage */
    zoom_image->image[studyN]=XCreateImage(display,visual,8,ZPixmap,0,pdata,xsize,ysize,8,0);
    zoom_image->dimage[studyN]=screen_format_ximage(zoom_image->image[studyN],studyN);
    /* Set the petimage widget's pointer */
    XtVaSetValues((Widget)zoom_image->widget[studyN],
    	petimageNimage,zoom_image->dimage[studyN],
  	XmNwidth,xsize,
	XmNheight,ysize,
	petimageNzoom,zoom,
	NULL);
    PetimageUpdate(zoom_image->widget[studyN]);
  }
}
/* Refresh the zoomed image (from the 8bit XImage buffer) */
void refresh_zoom(int studyN) {
  Display *d;
  int len,depth,a,b;
  if(zoom_image->dimage[studyN]==NULL) return;
  len=zoom_image->dimage[studyN]->width*zoom_image->dimage[studyN]->height;
  d=XtDisplay(toplevel);
  depth=DefaultDepth(d,XDefaultScreen(d));
  if(studyN==-1) {a=0; b=2;} else {a=studyN; b=studyN+1;}
  for(;a<b;a++) {
    screen_format_ximage_update(len,depth,zoom_image->image[a]->data,zoom_image->dimage[a]->data,a);
    PetimageUpdate(zoom_image->widget[a]);
  }
}

/* Set ROI drawing mode */
void set_ROI_drawmode(ROI *roi,int mode) {
  int studyN;
  for(studyN=0;studyN<1+(strlen(studies[1].filename)>4);studyN++) {
    XtVaSetValues((Widget)zoom_image->widget[studyN],petimageNroiMode,mode,NULL);
    switch(mode) {
      case -1:
        XtRemoveAllCallbacks((Widget)zoom_image->widget[studyN],petimageNmouseCb);
        my_ResetCursor((Widget)zoom_image->widget[studyN]);
        break;
      case ROI_TRACE:
        my_SetCrosshairCursor((Widget)zoom_image->widget[studyN]);
        XtAddCallback((Widget)zoom_image->widget[studyN],petimageNmouseCb,(void*)traceroi_cb,roi);
        break;
      case ROI_RECTANGULAR:
        my_SetCrosshairCursor((Widget)zoom_image->widget[studyN]);
        XtAddCallback((Widget)zoom_image->widget[studyN],petimageNmouseCb,(void*)rectangleroi_cb,roi);
        break;
      case ROI_CIRCULAR:
        my_SetCrosshairCursor((Widget)zoom_image->widget[studyN]);
        XtAddCallback((Widget)zoom_image->widget[studyN],petimageNmouseCb,(void*)circleroi_cb,roi);
        break;
      case ROI_ELLIPSE:
        my_SetCrosshairCursor((Widget)zoom_image->widget[studyN]);
        XtAddCallback((Widget)zoom_image->widget[studyN],petimageNmouseCb,(void*)ellipseroi_cb,roi);
        break;
      case ROI_MOVE: /* Note. The ROI pointer here doesn't actually contain a ROI. We use it to give move_roi_cb extra commands when it is used directly from double_roi_cb */
        if(roi)
          my_SetMoveCursor((Widget)zoom_image->widget[studyN]);
        else 
          my_SetHandCursor((Widget)zoom_image->widget[studyN]);
        XtAddCallback((Widget)zoom_image->widget[studyN],petimageNmouseCb,(void*)move_roi_cb,roi);
        break;
      case ROI_DOUBLE:
        my_SetHandCursor((Widget)zoom_image->widget[studyN]);
        XtAddCallback((Widget)zoom_image->widget[studyN],petimageNmouseCb,(void*)double_roi_cb,NULL);
        break;
      case ROI_ROTATE:
        my_SetHandCursor((Widget)zoom_image->widget[studyN]);
        XtAddCallback((Widget)zoom_image->widget[studyN],petimageNmouseCb,(void*)rotate_roi_cb,NULL);
	break;
      case ROI_PROFILE:
        XtVaSetValues((Widget)zoom_image->widget[studyN],petimageNroiMode,ROI_TRACE,NULL);
        my_SetCrosshairCursor((Widget)zoom_image->widget[studyN]);
        XtAddCallback((Widget)zoom_image->widget[studyN],petimageNmouseCb,(void*)profile_cb,roi);
	break;
      default:
        fprintf(stderr,"set_ROI_drawmode(): Unknown ROI mode '%d'\n",mode);
	return;
    }
  }
}

/* Display mouse coordinates */
static void coordinate_cb(Widget w,XtPointer client_data,XtPointer call_data) {
  XMotionEvent *ev=call_data;
  int frame,plane,study,zoom;
  static int errors=0;
  char msg[32];
  int x,y;
  XtVaGetValues(w,petimageNframe,&frame,petimageNplane,&plane,petimageNstudy,&study,petimageNzoom,&zoom,NULL);
  if(find_frame_plane_index(&studies[study],frame-1,plane-1,&frame,&plane)) {
    strcpy(msg,"Error");
    fprintf(stderr,"coordinate_cb(): Cannot find indexes for frame %d and plane %d\n",frame,plane);
    errors++;
    if(errors>30) {
      fprintf(stderr,"coordinate_cb(): Got tired of these errors. Callback removed\n");
      XtRemoveCallback(w,petimageNhoverCb,coordinate_cb,NULL);
    }
  } else {
    x=ev->x/zoom;
    y=ev->y/zoom;
    if(x<0 || y<0 || x>studies[study].imagepack.dimx || y>studies[study].imagepack.dimy) {
      strcpy(msg,"Error");
      fprintf(stderr,"coordinate_cb(): Warning ! point (%d,%d) is outside image bounds !\n",x,y);
    } else {
      sprintf(msg,"(%d,%d): %.3f",x,y,studies[study].imagepack.m[plane][y][x][frame]);
    }
  }
  XmTextFieldSetString(message_w2,msg);
}

/* Active the selected ROI */
static void roi_select_cb(Widget w,XtPointer client_data, XtPointer call_data) {
  ROI *roi=(ROI*)call_data;
  char msg[32];
  if(roi->userdata) {
    roi_userdata *data=(roi_userdata*)roi->userdata;
    sprintf(msg, "ROI:%s  avg =~ %.3f, stdev =~ %.3f", roi->roiname, data->mean, data->dev);
    XmTextFieldSetString(message_w, msg);
  }

  XtVaSetValues((Widget)zoom_image->widget[0],petimageNselectedRoi,call_data,NULL);
  XtVaSetValues((Widget)zoom_image->widget[1],petimageNselectedRoi,call_data,NULL);
}

/* Roi manipulation commands */
static void roi_command_cb(Widget w,XtPointer client_data,XtPointer call_data) {
  XButtonEvent ev;
  KeySym key;
  ROI *selroi;
  key=XKeycodeToKeysym(XtDisplay(w),((XKeyEvent*)call_data)->keycode,0);
  XtVaGetValues(w,petimageNselectedRoi,&selroi,NULL);
  switch(key) {
    case XK_m:
      XtVaSetValues((Widget)zoom_image->widget[0],petimageNroiMode,ROI_MOVE,NULL);
      XtVaSetValues((Widget)zoom_image->widget[1],petimageNroiMode,ROI_MOVE,NULL);
      ev.x=((XKeyEvent*)call_data)->x;
      ev.y=((XKeyEvent*)call_data)->y;
      move_roi_cb(w,NULL,&ev);
      XtAddCallback((Widget)zoom_image->widget[0],petimageNmouseCb,(void*)move_roi_cb,NULL);
      XtAddCallback((Widget)zoom_image->widget[1],petimageNmouseCb,(void*)move_roi_cb,NULL);
      break;
    case XK_Delete:
      if(!selroi) {
        message_dialog("Please select a ROI first","Delete ROI");
	return;
      }
      /*selroi=*/ roi_delete(&roi_list,selroi);
      XtVaSetValues((Widget)zoom_image->widget[0],petimageNselectedRoi,NULL,NULL);
      XtVaSetValues((Widget)zoom_image->widget[1],petimageNselectedRoi,NULL,NULL);
#if 0
      if(selroi) {
        XtVaSetValues((Widget)zoom_image->widget[0],petimageNrequestRoi,selroi,NULL);
        XtVaSetValues((Widget)zoom_image->widget[0],petimageNrequestRoi,selroi,NULL);
      }
#endif
      PetimageUpdate(zoom_image->widget[0]);
      PetimageUpdate(zoom_image->widget[1]);
      break;
    default: printf("Bug: Unhandled keysym got into roi_command_cb() !\n"); break;
  }
}

/* A simple pixel-resize function */
static void pixel_resize(int frame,float ***src, float *targ,float *min,float *max,int width,int height,int zoom) {
  float *dataptr;
  int xsize,ysize,k=0;
  int i,j,z,z2;
  xsize=width*zoom;
  ysize=height*zoom;
  for(i=0;i<width;i++) {
    for(j=0;j<height;j++) {
      float val;
      val=src[i][j][frame];
      if(val>*max)
        *max=val;
      if(val<*min)
        *min=val;
      for(z=0;z<zoom;z++) {
        targ[k]=val;
	k++;
      }
    }
    dataptr=&targ[k]-xsize;
    for(z=0;z<zoom-1;z++) {
      for(z2=0;z2<xsize;z2++) {
        targ[k]=*dataptr;
	dataptr++; k++;
      }
      dataptr-=xsize;
    }
  }
}

/* Resize and interpolate missing pixels	*/
/* (Numerical recepies in C, pages 123-124)	*/
static void smooth_resize(int frame,float ***src, float *targ,float *min,float *max,int width,int height,int zoom) {
  int         i,j,n,m;
  float       t,u;
  for(i=0; i<height-1; i++){
    for(j=0; j<width-1; j++){

      for(n=0; n<zoom; n++){
        for(m=0; m<zoom; m++){
	  int x,y,linear;

	  t=(n+0.5)/(float)zoom;
	  u=(m+0.5)/(float)zoom;
	 
	  x=j*zoom+m+1;
	  y=i*zoom+n+1;
	  linear=y*width*zoom+x;
	  targ[linear]=
                (1-t)*(1-u)*src[i][j][frame] +
                t*(1-u)*src[i+1][j][frame] +
	        t*u*src[i+1][j+1][frame] + 
                (1-t)*u*src[i][j+1][frame];
	}
      }
    }
  }
  /* Get the minimum and maximum values */
  for(i=0; i<height; i++)
    for(j=0;j<width; j++) {
      if(src[i][j][frame]<*min) *min=src[i][j][frame];
      if(src[i][j][frame]>*max) *max=src[i][j][frame];
    }
}

