#ifndef ZOOM_IMAGES_H
#define ZOOM_IMAGES_H

#include "petimage.h"
#include "images.h"

typedef struct {
  int frame,plane;
  XImage *image[2];
  XImage *dimage[2];
  PetimageWidget widget[2];
} ZoomImage;

/* Initialize */
extern void init_zoom_images(void);

/* Hide image list and show zoom widget. */
/* Set and scale the image */
extern void set_zoom_image(int frame,int plane,int frame2,int plane2,int zoom,int interpolate);

/* Scale the selected zoom image(s) */
extern void scale_image(int zoom,int interpolate);

/* Get back to image list */
extern void zoom_stop(int refresh);

/* Refresh zoomed image */
extern void refresh_zoom(int studyN);

/* ROI drawing */
extern void set_ROI_drawmode(ROI *roi,int mode);

/* Get the zoom image widget */
extern PetimageWidget get_zoom_image_widget(void);

/* Get the zoomed image (returns the first image) */
extern ZoomImage *get_zoom_image(void);

#endif

