﻿/******************************************************************************
 *
 * Copyright (c) 2009 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using TPClib;
using TPClib.Image;

namespace $safeprojectname$
{
    /// <summary>
    /// Console program using TPClib library.
    /// </summary>
    class Program: ConsoleProgram
    {
        /// <summary>
        /// File that is opened.
        /// </summary>
        string filename = "";
        /// <summary>
        /// Resolves program arguments given from command line.
        /// </summary>
        /// <param name="args"></param>
        public new void ResolveParameters(string[] args) {
            for (int i = 0; i < args.Length; i++)
            {
                if (args[i].Equals("--help") || args[i].Equals("-h")) {
                    PrintInfo();
                    return;
                }
            }
            if (args.Length > 0)
                filename = args[0];
        }

        /// <summary>
        /// Main program.
        /// </summary>
        /// <param name="args">arguments passed from command line</param>
        static void Main(string[] args)
        {
            Program program = new Program();
            program.programname = "no program name";
            program.description = "no description";
            program.usage = "no usage information";
            program.ResolveParameters(args);

            if (program.filename.Length > 0)
            {
                ImageFile imagefile = ImageFile.ReadFile(program.filename);
                float mean = imagefile.image.GetMean();
                Console.WriteLine("Image mean value=" + mean);
            }
        }
    }
}
