/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.IO;
using System.Runtime.InteropServices;

namespace TPClib.Curve
{
    /// <summary>
    /// Interfile curve file
    /// </summary>
    [ClassInterface(ClassInterfaceType.AutoDual), ComSourceInterfacesAttribute(typeof(Ifile))]
    public class IFCurveFile : CurveFile
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        public IFCurveFile()
        {
            throw new System.NotImplementedException();
        }

        /// <summary>
        /// Read IF file contents and create a Multicurve object, emptying its old contents
        /// </summary>
        public override void ReadFile()
        {
            if (!checkFormat(filename)) throw new TPCIFFileException("Fileformat not recognized.");

        }

        /// <summary>
        /// Checks file format based on filename extension.
        /// </summary>
        /// <param name="filename">full path to file</param>
        /// <returns>true if file is a IF file</returns>
        /// <exception cref="TPCIFFileException">if there was a read problem</exception>
        public static bool checkFormat(string filename)
        {
            FileInfo file = new FileInfo(filename);            
            //if (file.Extension.CompareTo("if") == 0 || file.Extension.CompareTo("IF") == 0)
            
            if (String.Compare(file.Extension, "if", true) == 0) //case insensitive comparison
            {
                //try to read file with readFile()
                try
                {
                    IFCurveFile iffile = new IFCurveFile();
                    iffile.filename = filename;
                    iffile.ReadFile();
                    return true;
                } catch(Exception) {
                    return false;
                }          
            }
            else
            {
                return false;
            }
        }
    }
}
