﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using System.Data;
using System.IO;
using System.Text.RegularExpressions;

namespace TPClib.Curve
{
    /// <summary>
    /// Class for RESfile unit tests
    /// </summary>
    [TestFixture]
    public class NUnitTestbench_RESfile
    {
        private static string[] files = 
        {
            @"P:\\data\\res\\temp.res",
            @"P:\\data\\res\\us1244.res",
            @"P:\\data\\res\\testi.res"
        };

        /// <summary>
        /// Inits the Nunit testbench for resfile
        /// </summary>
        [SetUp]
        public void Init()
        {
        }

        /// <summary>
        /// Test many different resfiles. Reads them, writes into disk and compares with resmatch
        /// </summary>
        [Test]
        public void Test_RESFile_Variations()
        {
            RESFile file = new RESFile();

            foreach (String filename in files)
            {
                file.ReadFile( filename );
                file.WriteFile("RES.res");
                Assert.IsTrue(TestHelpers.getStdOut(@"P:\\bin\\windows\\resmatch.exe", "RES.res " + filename) == 0);
            }
        }

        /// <summary>
        /// Tries to load wrong format file
        /// </summary>
        [Test]
        public void Test_FrongformatFile()
        {
            RESFile file = new RESFile();

            // we try to load file with wrong format 
            try
            {
                file.ReadFile("P:\\data\\dft\\Imadeus.dft");
            }
            catch (Exception e)
            {
                Assert.IsTrue( e is TPCRESFileException );
                Assert.IsTrue(e.Message.Contains("not in correct RES format"));
            }
        }

        /// <summary>
        /// Test many different resfiles. Reads them, writes into disk and compares with resmatch
        /// </summary>
        [Test]
        public void Test_EmptyFile()
        {
            RESFile file = new RESFile();

            // we try to load file with wrong format 
            try
            {
                file.ReadFile("P:\\data\\res\\blanc.res");
            }
            catch (Exception e)
            {
                Assert.IsTrue(e is TPCRESFileException);
                Assert.IsTrue(e.Message.Contains("not in correct RES format"));
            }
        }

        #region Help Routines
        private void CompareFiles(string fname, string resultFile)
        {
            string text1 = File.ReadAllText(fname);
            string text2 = File.ReadAllText(resultFile);
            Assert.AreEqual(text1, text2, "Tiedostot eivät ole merkilleen samat");
        }
        #endregion
    }
}
