﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;

namespace TPClib.Curve
{
    /// <summary>
    /// Parent comparing class for TAC headers
    /// </summary>
    public class TACComparer : System.Collections.Generic.IComparer<TAC>
    {
        /// <summary>
        /// Compare method.
        /// </summary>
        /// <param name="pFirstObject">First object to compare</param>
        /// <param name="pObjectToCompare">Second object to compare</param>
        /// <returns>Value indicating the result of comparison.</returns>
        Int32 System.Collections.Generic.IComparer<TAC>.Compare(TAC pFirstObject, TAC pObjectToCompare)
        {
            return 0;
        }

        /// <summary>
        /// Object which is used by find comparison function.
        /// </summary>
        public Object FindValue;

        /// <summary>
        /// Returns the finding function delegate.
        /// </summary>
        /// <returns></returns>
        public virtual Predicate<TAC> GetFindFunction()
        {
            //List<int> t;

            //new Predicate<int>(IsLessThanFive)
            return new Predicate<TAC>(FindNone);
        }
        /// <summary>
        /// An empty function because the base TACComparer has nothing data in to find. TACs with
        /// empty headers will never be on the find result list.
        /// </summary>
        protected bool FindNone(TAC t) { return false; }
    }
}