﻿/******************************************************************************
 *
 * Copyright (c) 2009 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;

namespace TPClib.Forms
{
    /// <summary>
    /// Class representing 2D plot line style
    /// </summary>
    public class LineStyle
    {
        /// <summary>
        /// Line width
        /// </summary>
        public float LineWidth;
        /// <summary>
        /// Line plot color
        /// </summary>
        public System.Drawing.Color Color;
        /// <summary>
        /// Show dots
        /// </summary>
        public bool ShowDots;
        /// <summary>
        /// Show lines
        /// </summary>
        public bool ShowLines;
        /// <summary>
        /// Show bars
        /// </summary>
        public bool ShowBars;
        /// <summary>
        /// Default constructor
        /// </summary>
        public LineStyle()
        {
            ShowDots = false;
            ShowLines = true;
            ShowBars = false;
            LineWidth = 1;
            Color = System.Drawing.Color.Gray;
        }
        /// <summary>
        /// Creates line style
        /// </summary>
        /// <param name="showDots">true for showing dots</param>
        /// <param name="showLines">true for showing lines</param>
        /// <param name="showBars">true for showing lines</param>
        /// <param name="width">line width</param>
        /// <param name="color">line color</param>
        public LineStyle(bool showDots, bool showLines, bool showBars, float width, System.Drawing.Color color)
        {
            ShowDots = showDots;
            ShowLines = showLines;
            ShowBars = showBars;
            LineWidth = width;
            Color = color;
        }
    }
}
