﻿/******************************************************************************
 *
 * Copyright (c) 2009 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;

namespace TPClib.Forms
{
    /// <summary>
    /// Shows axis as name list
    /// </summary>
    public class NameListAxis : PlotAxis
    {
        int interval;
        string[] names;

        public void GiveNameList(string[] namelist)
        {
            names = namelist;
            min = 0;
            max = namelist.Length + 1;
        }
        /// <summary>
        /// Returns starting graphics location 
        /// </summary>
        /// <returns>location in axis</returns>
        public override double ResetInterval()
        {
            interval = 0;
            return (double)interval;
        }
        /// <summary>
        /// Returns current axis value as string
        /// </summary>
        /// <returns>string representation of current axis value</returns>
        public override string GetTextOfCurrentInterval()
        {
            if (interval >= names.Length) return "OVERFLOW";
            return names[interval];
        }
        /// <summary>
        /// Steps to the next interval
        /// </summary>
        /// <returns>value of interval</returns>
        public override double NextInterval()
        {
            interval++;
            return interval;
        }
        /// <summary>
        /// Calculates axis point place between (0-1). 0 is first interval and 1 is last interval.
        /// </summary>
        /// <param name="x">the time value</param>
        /// <returns>x value from 0 to 1</returns>
        public override double GetPlace(double x)
        {
            return x / max + 0.5;
        }
    }
}
