﻿/******************************************************************************
 *
 * Copyright (c) 2009 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;

namespace TPClib.Forms
{
    /// <summary>
    /// Scale type for display
    /// </summary>
    public enum ScaleType
    {
        /// <summary>
        /// Scaling does not change
        /// </summary>
        Static = 0,
        /// <summary>
        /// Scaling is fitted to display region
        /// </summary>
        Fit_To_Screen,
        /// <summary>
        /// Scaling is logarithic and fitted to display region
        /// </summary>
        Log
    }
    /// <summary>
    /// Main class for axis.
    /// </summary>
    public abstract class PlotAxis
    {

        /// <summary>
        /// Caption of the axis
        /// </summary>
        public string Caption = "";

        /// <summary>
        /// Maximum value on the axis (by interval)
        /// </summary>
        public double max;

        /// <summary>
        /// Minimum value on the axis (by interval)
        /// </summary>
        public double min;
        /// <summary>
        /// Line style for axis
        /// </summary>
        public LineStyle style = new LineStyle();
        /// <summary>
        /// Maximum value 
        /// </summary>
        protected double value_max;
        /// <summary>
        /// Minimum value
        /// </summary>
        protected double value_min;
        /// <summary>
        /// Returns starting graphics location 
        /// </summary>
        /// <returns>location in axis</returns>
        public abstract double ResetInterval();
        /// <summary>
        /// Returns current axis value as string
        /// </summary>
        /// <returns>string representation of current axis value</returns>
        public abstract string GetTextOfCurrentInterval();
        /// <summary>
        /// Calculates axis point place between (0-1). 0 is first interval and 1 is last interval.
        /// </summary>
        /// <param name="x">the time value</param>
        /// <returns>x value from 0 to 1</returns>
        public abstract double GetPlace(double x);
        /// <summary>
        /// Steps to the next interval
        /// </summary>
        /// <returns>value of interval</returns>
        public abstract double NextInterval();
    }
}
