﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Collections;

using NUnit.Framework;

namespace TPClib.Image
{
    /// <summary>
    /// Stream of voxels, whose datatype
    /// and ordering are described by the header file
    /// </summary>
    public class Analyze75File : ImageFile
    {
        /// <summary>
        /// 
        /// </summary>
        private Analyze75Header aheader;

        /// <summary>
        /// 
        /// </summary>
        private Analyze75Image aimage;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="basename"></param>
        public Analyze75File(string basename)
        {
            if (!File.Exists(basename + ".hdr"))
                throw new Exception("No header file.");

            if (!File.Exists(basename + ".img"))
                throw new Exception("No image file.");

            this.filename = basename;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="filename"></param>
        /// <param name="header"></param>
        public Analyze75File(string filename,
            Analyze75Header header)
        {
            this.aimage = Analyze75Image.CreateDataStructure(
                filename, header );
        }

        /// <summary>
        /// 
        /// </summary>
        public override void ReadFile()
        {
            aheader = new Analyze75Header();
            aheader.Read(filename + ".hdr");
            aimage = Analyze75Image.CreateDataStructure(
                filename + ".img", aheader);
            aimage.Read(filename + ".img");

            this.header = aheader;
            this.image = aimage;            
        }

        /// <summary>
        /// 
        /// </summary>
        public override void WriteFile()
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// 
        /// </summary>
        /// </remarks>
        /// <param name="filename"></param>
        public void Read(string filename)
        {
            aimage.Read(filename);
        }

        /// <summary>
        /// Writes the Analyze 7.5 file to disk.
        /// </summary>
        public void Write(string filename)
        {
            aimage.Write(filename);
        }

        /// <summary>
        /// 
        /// </summary>
        public int Frames
        {
            get { return aimage.Frames(); }
        }

    }



    /// <summary>
    /// 
    /// </summary>
    public class TPCAnalyzeException : Exception
    {
        /// <summary>
        /// 
        /// </summary>
        public TPCAnalyzeException()
        {
            
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="msg"></param>
        public TPCAnalyzeException(string msg): base(msg)
        {
            
        }
    }
}

