﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Runtime.InteropServices;

namespace TPClib.Image
{
    /// <summary>
    /// Swaps array of bytes.
    /// </summary>
    [ClassInterface(ClassInterfaceType.AutoDual), ComSourceInterfacesAttribute(typeof(Ifile))]
    public class BitSwapper
    {
        /// <summary>
        /// Swaps byte array in smaller parts defined by parameters.
        /// </summary>
        /// <param name="data">swapped data</param>
        /// <param name="start">start index for swap</param>
        /// <param name="final">last swapped index</param>
        /// <param name="step">length of one swap operation</param>
        public static void SwapLoop(byte[] data, int start, int final, int step)
        {
            for (int i = start; i <= final; i += step)
            {
                Swap(data, i, step);
            }
        }

        /// <summary>
        /// Swaps bytes in array.
        /// </summary>
        /// <param name="buf">target array</param>
        /// <param name="start">swap start [0..buf.Length]</param>
        /// <param name="length">swap length [buf.Length-start]</param>
        public static void Swap(byte[] buf, int start, int length)
        {
            decimal d = length / 2;
            int end = (int)Decimal.Floor(d);
            for (int i = 0; i < end; i++)
            {
                byte temp = buf[start + i];
                buf[start + i] = buf[start + length - 1 - i];
                buf[start + length - 1 - i] = temp;
            }
        }
    }
}