﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System.Runtime.InteropServices;

namespace TPClib.Image
{
    /// <summary>
    /// Constants for DICOM data I/O with medcon-library.
    /// </summary>
    [ClassInterface(ClassInterfaceType.AutoDual), ComSourceInterfacesAttribute(typeof(Ifile))]
    public sealed class DicomConstants
    {
        /// <summary>
        /// Maximum number of dimensions
        /// </summary>
        public const int MAX_DIMS = 8;
        /// <summary>
        /// Library version
        /// </summary>
        public const string LIBVERS = "alpha";
        /// <summary>
        /// VECT_TOTAL == 9
        /// </summary>
        public const int VECT_TOTAL = 9;
        /// <summary>
        /// 1
        /// </summary>
        public const int ONE = 1;
        /// <summary>
        /// 0
        /// </summary>
        public const int ZERO = 0;
        /// <summary>
        /// YES == 1
        /// </summary>
        public const int YES = ONE;
        /// <summary>
        /// NO == 0
        /// </summary>
        public const int NO = ZERO;
        /// <summary>
        /// UNKNOWN == 0
        /// </summary>
        public const int UNKNOWN = ZERO;
        /// <summary>
        /// LITTLE_ENDIAN == 1
        /// </summary>
        public const int LITTLE_ENDIAN = ONE;
        /// <summary>
        /// BIG_ENDIAN == 0
        /// </summary>
        public const int BIG_ENDIAN = ZERO;
        /// <summary>
        /// ONE_KB_OFFSET =) 1024
        /// </summary>
        public const int ONE_KB_OFFSET = 1024;
        /// <summary>
        /// TWO_KB_OFFSET == 2048
        /// </summary>
        public const int TWO_KB_OFFSET = 2048;
        /// <summary>
        /// INPUT_NORM_STYLE == 1
        /// </summary>
        public const int INPUT_NORM_STYLE = 1;
        /// <summary>
        /// INPUT_ECAT_STYLE == 2
        /// </summary>
        public const int INPUT_ECAT_STYLE = 2;
        /// <summary>
        /// MAX_PATH == 256
        /// </summary>
        public const int MAX_PATH = 256;
        /// <summary>
        /// MAX_LIST == 256
        /// </summary>
        public const int MAX_LIST = 256;
        /// <summary>
        /// ARG_FILE == 0
        /// </summary>
        public const int ARG_FILE = 0;
        /// <summary>
        /// ARG_CONV == 1
        /// </summary>
        public const int ARG_CONV = 1;
        /// <summary>
        /// ARG_EXTRACT == 2
        /// </summary>
        public const int ARG_EXTRACT = 2;
        /// <summary>
        /// FILES == 0
        /// </summary>
        public const int FILES = 0;
        /// <summary>
        /// CONVS == 1
        /// </summary>
        public const int CONVS = 1;

        /// <summary>
        /// PASS 0
        /// </summary>
        public const int PASS0 = 0;
        /// <summary>
        /// PASS 1
        /// </summary>
        public const int PASS1 = 1;
        /// <summary>
        /// PASS 2
        /// </summary>
        public const int PASS2 = 2;

        /// <summary>
        /// output message level 1
        /// </summary>
        public const int LEVEL_MESG = 1;
        /// <summary>
        /// output message level 2
        /// </summary>
        public const int LEVEL_WARN = 2;
        /// <summary>
        /// output message level 3
        /// </summary>
        public const int LEVEL_ERR = 3;
        /// <summary>
        /// output message level 4
        /// </summary>
        public const int LEVEL_ALL = 4;

        /* supported color modes */
        /// <summary>
        /// 256 indexed colors
        /// </summary>
        public const int COLOR_INDEXED = 0;
        /// <summary>
        /// 24bit true  colors
        /// </summary>
        public const int COLOR_RGB = 1;
        /// <summary>
        /// total+1 conversion formats supported (==14)
        /// </summary>
        public const int MAX_FRMTS = 14;
        /// <summary>
        /// PrintTag limit in library (==100)
        /// </summary>
        public const int MAX_CHARS = 100;
        /// <summary>
        /// total acquisitions + 1
        /// </summary>
        public const int MAX_ACQUISITIONS = 6;

        /* ECAT sort order */
        /// <summary>
        /// Anatomical sort order
        /// </summary>
        public const int ANATOMICAL = 1;
        /// <summary>
        /// Frame sort order
        /// </summary>
        public const int BYFRAME = 2;
        /// <summary>
        /// Patient orientation
        /// </summary>
        public enum Pat_Orient
        {
            /// <summary>
            /// Left
            /// </summary>
            LEFT = 1,
            /// <summary>
            /// Right 
            /// </summary>
            RIGHT = 2,
            /// <summary>
            /// Anterior
            /// </summary>
            ANTERIOR = 3,
            /// <summary>
            /// Posterior
            /// </summary>
            POSTERIOR = 4,
            /// <summary>
            /// Head
            /// </summary>
            HEAD = 5,
            /// <summary>
            /// Feet
            /// </summary>
            FEET = 6
        }

        /* patient orientation */
        /// <summary>
        /// head first in scanner
        /// </summary>
        public const int HEADFIRST = 1;
        /// <summary>
        /// feet first in scanner
        /// </summary>
        public const int FEETFIRST = 2;

        /* slice orientation */
        /* consider a patient on  */
        /* his back on the table, */
        /* then the direction is: */
        /// <summary>
        /// Transaxial orientation 
        /// </summary>
        public const int TRANSAXIAL = 1;             /* //  device ;_|_ ground */
        /// <summary>
        /// Sagittal orientation
        /// </summary>
        public const int SAGITTAL = 2;             /* _|_ device ;_|_ ground */
        /// <summary>
        /// Coronal orientation
        /// </summary>
        public const int CORONAL = 3;             /* _|_ device ; // ground */

        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int SUPINE_HEADFIRST_TRANSAXIAL = 1;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int SUPINE_HEADFIRST_SAGITTAL = 2;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int SUPINE_HEADFIRST_CORONAL = 3;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int SUPINE_FEETFIRST_TRANSAXIAL = 4;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int SUPINE_FEETFIRST_SAGITTAL = 5;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int SUPINE_FEETFIRST_CORONAL = 6;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int PRONE_HEADFIRST_TRANSAXIAL = 7;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int PRONE_HEADFIRST_SAGITTAL = 8;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int PRONE_HEADFIRST_CORONAL = 9;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int PRONE_FEETFIRST_TRANSAXIAL = 10;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int PRONE_FEETFIRST_SAGITTAL = 11;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int PRONE_FEETFIRST_CORONAL = 12;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int DECUBITUS_RIGHT_HEADFIRST_TRANSAXIAL = 13;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int DECUBITUS_RIGHT_HEADFIRST_SAGITTAL = 14;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int DECUBITUS_RIGHT_HEADFIRST_CORONAL = 15;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int DECUBITUS_RIGHT_FEETFIRST_TRANSAXIAL = 16;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int DECUBITUS_RIGHT_FEETFIRST_SAGITTAL = 17;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int DECUBITUS_RIGHT_FEETFIRST_CORONAL = 18;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int DECUBITUS_LEFT_HEADFIRST_TRANSAXIAL = 19;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int DECUBITUS_LEFT_HEADFIRST_SAGITTAL = 20;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int DECUBITUS_LEFT_HEADFIRST_CORONAL = 21;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int DECUBITUS_LEFT_FEETFIRST_TRANSAXIAL = 22;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int DECUBITUS_LEFT_FEETFIRST_SAGITTAL = 23;
        /// <summary>
        /// patient/slice combined
        /// </summary>
        public const int DECUBITUS_LEFT_FEETFIRST_CORONAL = 24;
        /// <summary>
        /// total orientations + 1
        /// </summary>
        public const int MAX_ORIENT = 25;

        /* detector rotation */
        /// <summary>
        /// clockwise
        /// </summary>
        public const int ROTATION_CW = 1;
        /// <summary>
        /// counter-clocwise
        /// </summary>
        public const int ROTATION_CC = 2;

        /* detector motion   */
        /// <summary>
        /// stepped
        /// </summary>
        public const int MOTION_STEP = 1;
        /// <summary>
        /// continuous
        /// </summary>
        public const int MOTION_CONT = 2;
        /// <summary>
        /// during step
        /// </summary>
        public const int MOTION_DRNG = 3;

        /// <summary>
        /// gated spect nesting outer level
        /// </summary>
        public const int GSPECT_NESTING_SPECT = 1;
        /// <summary>
        /// gated spect nesting outer level
        /// </summary>
        public const int GSPECT_NESTING_GATED = 2;
        /// <summary>
        /// gated heart rate
        /// </summary>
        public const int HEART_RATE_ACQUIRED = 1;
        /// <summary>
        /// gated heart rate
        /// </summary>
        public const int HEART_RATE_OBSERVED = 2;
        /// <summary>
        /// image padding
        /// </summary>
        public const int PAD_AROUND = 1;
        /// <summary>
        /// image padding
        /// </summary>
        public const int PAD_TOP_LEFT = 2;
        /// <summary>
        /// image padding
        /// </summary>
        public const int PAD_BOTTOM_RIGHT = 3;

        /// <summary>
        /// max length of strings (==35)
        /// </summary>
        public const int MAXSTR = 35;
        /// <summary>
        /// maximun length UID string
        /// </summary>
        public const int UID_MAXSTR = 64;
        /// <summary>
        /// 777.777.0.0.0
        /// </summary>
        public const string STR_UID_CREATOR = "777.777.0.0.0";
        /// <summary>
        /// 0xffff
        /// </summary>
        public const int UNDEFINED_LENGTH = 0xffff;
    }
}