﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Runtime.InteropServices;

namespace TPClib.Image
{
    /// <summary>
    /// Event arguments for ImageFile I/O actions
    /// </summary>
    [ClassInterface(ClassInterfaceType.AutoDual), ComSourceInterfacesAttribute(typeof(Ifile))]
    public class IOProgressEventArgs : EventArgs
    {
        /// <summary>
        /// Creates new I/O event arguments
        /// </summary>
        /// <param name="percent">estimated percent of operation ready 100.0 ready</param>
        /// <param name="method">method where event occurred</param>
        /// <param name="desc">additional description of current process</param>
        public IOProgressEventArgs(float percent, System.Reflection.MethodBase method, string desc)
        {
            this.percent = percent;
            this.method = method;
        }
        /// <summary>
        /// Creates new I/O event arguments
        /// </summary>
        /// <param name="percent">estimated percent of operation ready 100.0 ready</param>
        /// <param name="method">method where event occurred</param>
        public IOProgressEventArgs(float percent, System.Reflection.MethodBase method)
        {
            this.percent = percent;
            this.method = method;
        }
        /// <summary>
        /// Method where event occurred
        /// </summary>
        public System.Reflection.MethodBase method;
        /// <summary>
        /// Estimated percent (in [0.0 .. 100.0]) ready from I/O operation
        /// </summary>
        public float percent;
        /// <summary>
        /// Additional description, or null.
        /// </summary>
        public string description;
        /// <summary>
        /// Prints out basic information about progress event.
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            if(description != null)
                return "[" + method.Name + "] ["+description+"] progress:" + percent.ToString() + "%";
            else
                return "[" + method.Name + "] progress:" + percent.ToString() + "%";
        }
    }
}