﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using System.IO;

namespace TPClib.Image
{
    /// <summary>
    /// Superclass for all testbenches in TPClib.Image namespace. Contains 
    /// some general methods such as acquiring external executable stdout as string and 
    /// event handler for event thrown from image format classes.
    /// </summary>
    public class NUnitTestbench
    {
        /// <summary>
        /// Event consumer for all events in tested class. Just prints event information.
        /// </summary>
        /// <param name="sender">object sending the event</param>
        /// <param name="e">event arguments</param>
        public void EventListener(object sender, IOProgressEventArgs e)
        {
            Console.WriteLine("event:" + sender.GetType() + " " + e);
        }
        /// <summary>
        /// Returns stdout of program 
        /// </summary>
        /// <param name="procname">program name</param>
        /// <param name="parameters">parameters</param>
        /// <param name="exitcode">executed program exit code</param>
        /// <returns>standard output stream contents</returns>
        protected string GetStdOut(string procname, string parameters, out int exitcode)
        {
            System.Diagnostics.Process proc = new System.Diagnostics.Process();
            if (!File.Exists(procname))
            {
                Assert.Fail("Command prompt executable [" + procname + "] was not found.");
            }
            proc.StartInfo.FileName = procname;
            proc.StartInfo.Arguments = parameters;
            proc.StartInfo.UseShellExecute = false;
            proc.StartInfo.RedirectStandardOutput = true;
            proc.Start();
            proc.WaitForExit(10000);
            exitcode = proc.ExitCode;
            string r = proc.StandardOutput.ReadToEnd();
            return r;
        }
        /// <summary>
        /// Returns stdout of program 
        /// </summary>
        /// <param name="procname">program name</param>
        /// <param name="parameters">parameters</param>
        /// <returns>standard output stream contents</returns>
        protected string GetStdOut(string procname, string parameters)
        {
            int exitcode;
            return GetStdOut(procname, parameters, out exitcode);
        }
        /// <summary>
        /// Returns stdout of program with filtered output
        /// </summary>
        /// <param name="procname">program name</param>
        /// <param name="parameters">parameters</param>
        /// <param name="grep">only lines containing this string are included in the results</param>
        /// <returns>filtered array of output strings</returns>
        protected string[] GetStdOut(string procname, string parameters, string grep)
        {
            string r = GetStdOut(procname, parameters);
            List<string> list = new List<string>();
            string[] lines = r.Split('\n');
            for (int i = 0; i < lines.Length; i++)
            {
                if (lines[i].Contains(grep))
                    list.Add(lines[i].Trim());
            }
            return list.ToArray();
        }
    }
}
