﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using NUnit.Framework;
using System.Runtime.InteropServices;
using System;
using System.Collections.Generic;
using System.IO;
using TPClib.Image;

namespace TPClib.Image
{
    /// <summary>
    /// Class for ImageFile unit tests using NUnit
    /// </summary>
    [TestFixture]
    public class NUnitTestbench_Imagefile : NUnitTestbench
    {
            /// <summary>
            /// Test version information.
            /// </summary>
            [Test]
            //[Ignore("Currently disabled")]
            public void Test1_0_test_versioninformation()
            {
                Console.WriteLine(Version.GetVersionInformation());
            }
            /// <summary>
            /// Unit test for ReadFile method.
            /// </summary>
            [Test]
            //[Ignore("Currently disabled")]
            public void Test1_1_ReadFile()
            {
                ImageFile file;
                //read once each data type
                //Analyze75
                file = ImageFile.ReadFile(@"P:\data\Analyze75\DYN_HEART_PET_16bit");
                Assert.IsTrue(file is Analyze75File);
                file = ImageFile.ReadFile(@"P:\data\Analyze75\DYN_HEART_PET_16bit");
                Assert.IsTrue(file is Analyze75File);
                //Ecat7
                file = ImageFile.ReadFile(@"P:\data\Ecat7\cell1.00_rsl.v");
                Assert.IsTrue(file is Ecat7File);
                //DICOM
                file = ImageFile.ReadFile(@"P:\data\DICOM\chirley_testdata\cell1\*");
                Assert.IsTrue(file is DicomFile);
                file = ImageFile.ReadFile(@"P:\data\DICOM\chirley_testdata\cell1\cell1.00.dcm");
                Assert.IsTrue(file is DicomFile);
            }
            /// <summary>
            /// Unit test for WriteFile method. 
            /// Write empty Analyze75 file.
            /// </summary>
            [Test]
            //[Ignore("Currently disabled")]
            public void Test2_1_WriteFile()
            {
                Analyze75File file = new Analyze75File(@"S:\temp\test", 10, 20, 30);
                Analyze75File.IOProgress += new ImageFile.IOProcessEventHandler(EventListener);
                if (File.Exists(@"S:\temp\test.hdr")) File.Delete(@"S:\temp\test.hdr");
                if (File.Exists(@"S:\temp\test.img")) File.Delete(@"S:\temp\test.img");
                ImageFile.WriteFile(file);
                ImageFile.ReadFile(@"S:\temp\test");
                Assert.IsTrue(file is Analyze75File);
                File.Delete(@"S:\temp\test.hdr");
                File.Delete(@"S:\temp\test.img");
            }
            /// <summary>
            /// Unit test for WriteFile method. 
            /// Write empty Ecat7 file.
            /// </summary>
            [Test]
            //[Ignore("Currently disabled")]
            public void Test2_2_WriteFile()
            {
                Ecat7File file = new Ecat7File(@"S:\temp\test.v", 10, 20, 30);
                Ecat7File.IOProgress += new ImageFile.IOProcessEventHandler(EventListener);
                ImageFile.WriteFile(file);
                ImageFile.ReadFile(@"S:\temp\test.v");
                Assert.IsTrue(file is Ecat7File);
                File.Delete(@"S:\temp\test.v");
            }
            /// <summary>
            /// Unit test for WriteFile method. 
            /// Write empty DICOM file.
            /// </summary>
            [Test]
            //[Ignore("Currently disabled")]
            public void Test2_3_WriteFile()
            {
                DicomFile file = new DicomFile(@"S:\temp\Test2_3_WriteFile", 10, 20, 30);
                DicomFile.IOProgress += new ImageFile.IOProcessEventHandler(EventListener);
                ImageFile.WriteFile(file);
                ImageFile.ReadFile(@"S:\temp\Test2_3_WriteFile*");
                Assert.IsTrue(file is DicomFile);
                FileInfo[] dicomfilenames = DicomFile.ResolveDicomFilenames(@"S:\temp\Test2_3_WriteFile*");
                foreach(FileInfo fi in dicomfilenames)
                    File.Delete(fi.FullName);
            }
    }
}
