﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices.ComTypes;
using System.Runtime.InteropServices;
using TPClib.Interfaces.Matlab;

namespace TPClib
{
    /// <summary>
    /// Point containing only integer values
    /// </summary>
    [ClassInterface(ClassInterfaceType.AutoDual), ComSourceInterfacesAttribute(typeof(Ievent))]
    public class IntPoint : Point
    {
        /// <summary>
        /// x-coordinate, (input/output)
        /// </summary>
        public new int x
        {
            get { return (int)base.x; }
            set { base.x = (int)value; }
        }
        /// <summary>
        /// y-coordinate, (input/output)
        /// </summary>
        public new int y
        {
            get { return (int)base.y; }
            set { base.y = (int)value; }
        }
        /// <summary>
        /// z-coordinate, (input/output)
        /// </summary>
        public new int z
        {
            get { return (int)base.z; }
            set { base.z = (int)value; }
        }
        /// <summary>
        /// Constructs point at specified location.
        /// </summary>
        /// <param name="x">x-coordinate</param>
        /// <param name="y">y-coordinate</param>
        /// <param name="z">z-coordinate</param>
        public IntPoint(int x, int y, int z)
            : base(x, y, z)
        {
        }
        /// <summary>
        /// Constructs point at specified location.
        /// </summary>
        /// <param name="p">location</param>
        public IntPoint(IntPoint p)
        {
            this.x = p.x;
            this.y = p.y;
            this.z = p.z;
        }
        /// <summary>
        /// Constructs point at location (0, 0, 0)
        /// </summary>
        public IntPoint() : base() { }
        /// <summary>
        /// Sets point location
        /// </summary>
        /// <param name="x">x-coordinate</param>
        /// <param name="y">y-coordinate</param>
        /// <param name="z">z-coordinate</param>
        public new void Set(int x, int y, int z)
        {
            this.x = x;
            this.y = y;
            this.z = z;
        }
        /// <summary>
        /// Sets point location.
        /// </summary>
        /// <param name="p">new location</param>
        public void Set(IntPoint p)
        {
            this.x = p.x;
            this.y = p.y;
            this.z = p.z;
        }
        /// <summary>
        /// Override of object's method.
        /// </summary>
        /// <returns>string representation of this object</returns>
        public override string ToString()
        {
            return base.ToString() + "(" + x + ", " + y + ", " + z + ")";
        }
        /// <summary>
        /// Addition operator
        /// </summary>
        /// <param name="p1">1st addition term point</param>
        /// <param name="p2">2nd addition term point</param>
        public static IntPoint operator +(IntPoint p1, IntPoint p2)
        {
            IntPoint r = new IntPoint();
            r.x = p1.x + p2.x;
            r.y = p1.y + p2.y;
            r.z = p1.z + p2.z;
            return r;
        }
    }
}