using System;
using System.Runtime.InteropServices;
using System.Threading;
using System.Runtime.InteropServices.ComTypes;

namespace TPClib.Interfaces.Matlab
{
	[InterfaceType(ComInterfaceType.InterfaceIsIDispatch)]
	public interface Ievent
	{
		[DispId(1)]
		void eval(string t_MatComm);
	}

	[ClassInterface(ClassInterfaceType.AutoDual), ComSourceInterfacesAttribute(typeof(Ievent))]
	public class Server : ConPntCnt 
	{	
		public Server() {
		}

		public void WriteLine(string t_MatMessage )
		{
			eval("disp " + t_MatMessage);
		}
	}
	/// <summary>
    /// System.Runtime.InteropServices.ComTypes.IConnectionPointContainer 
	/// </summary>
    [ComVisible(true)]
    public class ConPntCnt : IConnectionPointContainer 
	{
        protected ConnectionPnt m_SingleCon = null;

        public void FindConnectionPoint(ref Guid sinkID, out IConnectionPoint cp)
		{
            m_SingleCon = new ConnectionPnt();
			cp = m_SingleCon;
		}
        public void EnumConnectionPoints(out IEnumConnectionPoints cps)
		{
			throw new Exception("EnumConnectionPoints implementation not required\n");
		}
        /// <summary>
        /// Evaluates Matlab command
        /// </summary>
        /// <param name="matlabCommand">Matlab command as a string</param>
		public void eval( string matlabCommand )
		{	
			if( m_SingleCon != null )
				m_SingleCon.eval( matlabCommand );
		}
	
		public class ConnectionPnt : IConnectionPoint
		{
			private Ievent m_sink = null;

			public void eval( string t_MatComm )
			{	
				if( m_sink != null )
					m_sink.eval( t_MatComm );
			}

			public void Advise(object theSink, out int cookie)
			{
				if( m_sink != null )
					throw new Exception("Cannot Connect more than one sink to event, unintended usage\n");
				cookie = 1;
				m_sink = theSink as Ievent;
			}
			public void EnumConnections(out IEnumConnections cl)
			{
				throw new Exception("EnumConnections implementation not required\n");
			}
			public void GetConnectionInterface(out Guid sinkGuid)
			{
				throw new Exception("GetConnectionInterface implementation not required\n");
			}

			public void GetConnectionPointContainer(out IConnectionPointContainer cp)
			{
				throw new Exception("GetConnectionPointContainer implementation not required\n");
			}
			public void Unadvise(int cookie)
			{
				m_sink = null;
			}
		}
	}
}
