﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
namespace TPClib.Model
{
    /// <summary>
    /// Real valued function: R -> R.
    /// </summary>
    public delegate double Function(double x);

    /// <summary>
    /// Real valued function: R^n -> R.
    /// </summary>
    public delegate double RealFunction(Vector p);

    /// <summary>
    /// Function value at point x with parameters a.
    /// </summary>
    /// <param name="x">current x</param>
    /// <param name="a">parameter table</param>
    /// <returns>Function value at x with parameters a</returns>
    public delegate double ParameterFunction(double x, Vector a);

    /// <summary>
    /// Calcualtes approximate derivate of a funciton
    /// </summary>
    /// <param name="f">target function</param>
    /// <param name="x"></param>
    /// <param name="a"></param>
    /// <param name="i"></param>
    public delegate double ApproximateDerivate(ParameterFunction f, double x, Vector a, int i);

    /// <summary>
    /// Partial derivate of index i of vector a at the point x.
    /// </summary>
    /// <param name="x">current x</param>
    /// <param name="a">parameter table</param>
    /// <param name="dyda">partial derivate table</param>
    /// <returns>Function value at x with parameters a</returns>
    public delegate double PartialDerivate(double x, Vector a, Vector dyda);
}