﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using TPClib.Curve;
using System.Runtime.InteropServices;

namespace TPClib.Model
{
    /// <summary>
    /// Parent class for all 1D-interpolation methods. 
    /// </summary>
    [ClassInterface(ClassInterfaceType.AutoDual), ComSourceInterfacesAttribute(typeof(Ifile))]
    public abstract class InterpolationMethod
    {
        /// <summary>
        /// Handling type for external values
        /// </summary>
        public enum ExternalValueHandlingMethod {
            /// <summary>
            /// External values are set to zero.
            /// </summary>
            ZERO_VALUES,
            /// <summary>
            /// External values are extrapolated from preceding/following slope.
            /// </summary>
            EXTRAPOLATION,
            /// <summary>
            /// Preceding outside values are set to zero and following outside 
            /// values are extrapolated from preceding slope.
            /// </summary>
            PATLAK
        }

        /// <summary>
        /// Interpolates at data points.
        /// </summary>
        /// <param name="x">interpolation locations</param>
        /// <param name="data_x">x-values of data</param>
        /// <param name="data_y">y-values of data</param>
        /// <returns>y-values evaluated at locations x</returns>
        public abstract double[] Interpolate(double[] x, double[] data_x, double[] data_y, ExternalValueHandlingMethod m);
    }
}
