﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Runtime.InteropServices;

namespace TPClib.Model
{
    /// <summary>
    /// 
    /// </summary>
    [ClassInterface(ClassInterfaceType.AutoDual), ComSourceInterfacesAttribute(typeof(Ifile))]
    public class Linemethod
    {
        private Function f;
        private double brentTol;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="f"></param>
        /// <param name="tol"></param>
        public Linemethod(Function f, double tol)
        {
            this.f = f;
            this.brentTol = tol;
        }

        /// <summary>
        /// Line minimization.
        /// </summary>
        /// <param name="point">Point</param>
        /// <param name="xi">Direction</param>
        /// <returns>the minimum function value</returns>
        public double LineMinimum(ref Vector point, ref Vector xi)
        {
            if (point.Length != xi.Length)
                throw new OptimizationException("LineMinimum: Wrong argument");

            double a, x, b, fa, fx, fb, xmin, fmin;

            Brent brent = new Brent();

            // initial guess for brackets
            double inita = 0, initb = 1;

            // bracket to minimum
            brent.Bracket(inita, initb, f, out a, out x, out b, out fa, out fx, out fb);

            // Now, do the parabolic interpolation.
            fmin = brent.Minimize(a, x, b, brentTol, f, out xmin);

            // update minimized point and direction
            xi = xi * xmin;
            point = point + xi;

            return fmin;
        }
    }
}