﻿using System;
using System.Collections.Generic;
using System.Text;

namespace TPClib.Model
{

    [AttributeUsage(AttributeTargets.Class, AllowMultiple = true, Inherited = true)]
    public class ModelExtension : Attribute
    {
        private ModelInfo info = new ModelInfo("");

        public ModelInfo Info
        {
            get { return info; }
            set { info = value; }
        }


        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="name">Name of the Model</param>
        public ModelExtension(string name) { info.ModelName = name; }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="name">Name of the Model</param>
        /// <param name="description">Description about Model</param>
        public ModelExtension(string name, string description)
        {
            info.ModelName = name;
            info.Description = description;
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="name">Name of the Model</param>
        /// <param name="description">Description about Model</param>
        /// <param name="needs_input_function">Tells if the Model needs input function</param>
        public ModelExtension(string name, string description, bool needs_input_function)
        {
            info.ModelName = name;
            info.Description = description;
            info.NeedsInputFunction = needs_input_function;
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="name">Name of the Model</param>
        /// <param name="description">Description about Model</param>
        /// <param name="needs_input_function">Tells if the Model needs input function</param>
        /// <param name="derivative">True if the Model is derivative (better fit methods can be used)</param>
        public ModelExtension(string name, string description, bool needs_input_function, bool derivative)
        {
            info.ModelName = name;
            info.Description = description;
            info.NeedsInputFunction = needs_input_function;
            info.IsDerivative = derivative;
        }
    }
}
