﻿/******************************************************************************
 *
 * Copyright (c) 2009 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Runtime.InteropServices;

namespace TPClib.Model
{

    /// <summary>
    /// Information about Model.
    /// </summary>
    [ClassInterface(ClassInterfaceType.AutoDual), ComSourceInterfacesAttribute(typeof(Ifile))]
    public class ModelInfo
    {
        /// <summary>
        /// Name of the Model.
        /// </summary>
        public string ModelName = "";

        /// <summary>
        /// Description about Model.
        /// </summary>
        public string Description = "";

        /// <summary>
        /// Tells if the Model needs input function(s).
        /// </summary>
        public bool NeedsInputFunction {
            get {
                return inputFunctions.Length > 0;
            }
        }

        /// <summary>
        /// Input function descriptions
        /// </summary>
        public string[] inputFunctions = new string[0];

        /// <summary>
        /// True if the Model is derivative (better fit methods can be used)
        /// </summary>
        public bool IsDerivative = false;

        /// <summary>
        /// Type of Model class
        /// </summary>
        public Type ClassType = typeof(TPClib.Model.Model);

        /// <summary>
        /// Parameters needed by model
        /// </summary>
        public ModelParameter[] Parameters = new ModelParameter[0];

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="name">Name of the Model</param>
        public ModelInfo(string name) { ModelName = name; }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="name">Name of the Model</param>
        /// <param name="description">Description about Model</param>
        public ModelInfo(string name, string description) { ModelName = name; Description = description; }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="name">Name of the Model</param>
        /// <param name="description">Description about Model</param>
        /// <param name="input_functions">Descriptions of input functions</param>
        public ModelInfo(string name, string description, params string[] input_functions)
        {
            ModelName = name;
            Description = description;
            inputFunctions = input_functions;
        }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="name">Name of the Model</param>
        /// <param name="description">Description about Model</param>
        /// <param name="derivative">True if the Model is derivative (better fit methods can be used)</param>
        /// <param name="input_functions">Descriptions of input functions</param>
        public ModelInfo(string name, string description, bool derivative, params string[] input_functions)
        {
            ModelName = name;
            Description = description;
            inputFunctions = input_functions;
            IsDerivative = derivative;
        }

        /// <summary>
        /// Model as string (ModelName)
        /// </summary>
        /// <returns>Model as string (ModelName)</returns>
        public override string ToString()
        {
            return ModelName;
        }
    }
}
