﻿/******************************************************************************
 *
 * Copyright (c) 2009 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System.Runtime.InteropServices;

namespace TPClib.Model
{


    /// <summary>
    /// This class defines one parameter used in model ( Name, Value, Min, Max )
    /// </summary>
    [ClassInterface(ClassInterfaceType.AutoDual), ComSourceInterfacesAttribute(typeof(Ifile))]
    public class ModelParameter
    {
        /// <summary>
        /// Name of the parameter (for example A or Ka)
        /// </summary>
        public string Name;

        /// <summary>
        /// Minimum value of parameter
        /// </summary>
        public double Min;

        /// <summary>
        /// Maximum value of parameter
        /// </summary>
        public double Max;

        /// <summary>
        /// Initial value of parameter
        /// </summary>
        public double Initial;

        /// <summary>
        /// Current value of parameter
        /// </summary>
        public double Value;

        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="name">Name of the parameter</param>
        /// <param name="min">Minimum value of parameter</param>
        /// <param name="max">Maximum value of parameter</param>
        /// <param name="value">Initial value of parameter</param>
        public ModelParameter(string name, double min, double max, double initial)
        {
            Name = name;
            Min = min;
            Max = max;
            Initial = initial;
            Value = initial;
        }

        /// <summary>
        /// Returns the parameter as string
        /// </summary>
        public override string ToString()
        {
            return
                Name +
                " val=" + Value.ToString("f5") +
                " (" + Min.ToString("f5") +
                "-" + Max.ToString("f5") + ")";
        }
    }

}
