﻿/******************************************************************************
 *
 * Copyright (c) 2009 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/

using System;
using System.Runtime.InteropServices;

namespace TPClib.Model
{
    /// <summary>
    /// General class for multiple-time graphical analysis (MTGA).
    /// <seealso cref="http://www.turkupetcentre.net/modelling/methods/mtga.html"/>
    /// </summary>
    [ClassInterface(ClassInterfaceType.AutoDual), ComSourceInterfacesAttribute(typeof(Ifile))]
    public abstract class MultipleTimeGraphicalAnalysis
    {
        /// <summary>
        /// Constructor without parametres
        /// </summary>
        public MultipleTimeGraphicalAnalysis() { }
        /// <summary>
        /// Constructor with parameters
        /// </summary>
        /// <param name="reference_times">milliseconds from start of acquisition</param>
        /// <param name="reference">reference activity values</param>
        /// <param name="tac_times">data time points in milliseconds from acquisition</param>
        /// <param name="tac">data activity values</param>
        public MultipleTimeGraphicalAnalysis(Vector reference_times, Vector reference, Vector tac_times, Vector tac) {
            if (reference_times.Length != reference.Length) throw new ModelException("Number of time values must match number of reference activity values");
            if (tac_times.Length != tac.Length) throw new ModelException("Number of time values must match number of TAC data points");
        }
        /// <summary>
        /// Calculates model value.
        /// </summary>
        /// <returns>model parameter value(s)</returns>
        public abstract double[] Calculate();
        /// <summary>
        /// Returns fitted curve for visualization
        /// </summary>
        /// <param name="parameters">model parameter value(s)</param>
        /// <returns>curve of fitted model plot</returns>
        public Vector GetFitCurve(double[] parameters) {
            throw new NotImplementedException();
        }
    }
}
