﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using System.IO;

namespace TPClib.Model
{
    /// <summary>
    /// Test cases for Interpolation
    /// </summary>
    [TestFixture]
    public class NUnitTestbench_Interpolation
    {
        // Help routine.
        private void Print(double[] s)
        {
            foreach (double x in s)
            {
                Console.Write(x + "  ");
            }
            Console.WriteLine();
        }

        /// <summary>
        /// Interpolate
        /// Five timepoints (1,2,..,5),
        /// values 1.0, 2.0,...5.0
        /// new frames (1.5, 2.5,.., 5.5)
        /// </summary>
        [Test]
        public void Test2_1_Interpolate()
        {
            LinearInterpolation sut = new LinearInterpolation();

            int length = 5;
            double[] xin = new double[length];
            double[] yin = new double[length];
            double[] xout = new double[length];
            double[] yout = new double[length];

            for (int i = 0; i < length; i++)
            {
                xin[i] = i + 1;
                yin[i] = i + 1.0;
                xout[i] = i + 1.5;
            }
            //double[] yout;
            double[] notneeded;
            double[] notneeded2;
            LinearInterpolation.Interpolate(xin, yin, xout, out yout, out notneeded, out notneeded2);

            Assert.AreEqual(1.5, yout[0]);
            Assert.AreEqual(2.5, yout[1]);
            Assert.AreEqual(3.5, yout[2]);
            Assert.AreEqual(4.5, yout[3]);
            Assert.AreEqual(5.0, yout[4]);
        }

        /// <summary>
        /// Interpolate
        /// Three timepoints x (3,4,5),
        /// values y 3.0, 4.0, 5.0
        /// New frames x (1.5,3.5)
        /// </summary>
        [Test]
        public void Test2_2_Interpolate()
        {
            int nrin = 3;
            int nrout = 2;

            double[] xin = new double[nrin],
                yin = new double[nrin],
                xnew1 = new double[nrout],
                yout = new double[nrout];

            for (int i = 0; i < nrout; i++)
            {
                xin[i] = i + 3;
                yin[i] = i + 3;
            }
            xnew1[0] = 1.5;
            xnew1[1] = 3.5;

            LinearInterpolation sut = new LinearInterpolation();

            double[] notNeeded3;
            double[] notNeeded4;
            LinearInterpolation.Interpolate(xin, yin, xnew1, out yout, out notNeeded3, out notNeeded4);
            Assert.AreEqual(0.0, yout[0]);
            Assert.AreEqual(3.5, yout[1]);
        }

        /// <summary>
        /// InterpolateToPETFrames
        /// </summary>
        [Test]
        public void Test2_3_InterpolateToPETFrames()
        {
          
            double[] x = new double[] { 0, 1, 2, 3, 4 };
            double[] y = new double[] { 0, 1, 2, 3, 4 };
            double[] newx1 = new double[] { 0, 1, 2, 3, 4 };
            double[] newx2 = new double[] { 0, 1, 2, 3, 4 };
            double[] newy = new double[] { 0, 1, 2, 3, 4 };
            double[] _1st = new double[] { 0, 0, 0, 0, 0 };
            double[] _2nd = new double[] { 0, 0, 0, 0, 0 };
            LinearInterpolation.InterpolateToPETFrames(x, y, newx1, newx2, out newy, out _1st, out _2nd);

            Print(x);
            Print(y);
            Print(newx1);
            Print(newx2);
            Print(newy);
            Print(_1st);
            Print(_2nd);

            Assert.AreEqual(0, _1st[0]);
            Assert.AreEqual(0.5, _1st[1]);
            Assert.AreEqual(2, _1st[2]);
            Assert.AreEqual(4.5, _1st[3]);
            Assert.AreEqual(8, _1st[4]);

            Assert.AreEqual(0, _2nd[0]);
            Assert.AreEqual(0.25, _2nd[1]);
            Assert.AreEqual(1.5, _2nd[2]);
            Assert.AreEqual(4.75, _2nd[3]);
            Assert.AreEqual(11, _2nd[4]);
        }

        /// <summary>
        /// InterpolateToFrameEndTimes
        /// </summary>
        [Test]
        public void Test2_4_InterpolateToFrameEndTimes()
        {
            LinearInterpolation sut = new LinearInterpolation();
            double[] x1 = new double[] { 0, 1, 2, 3, 4 };
            double[] x2 = new double[] { 1, 2, 3, 4, 5 };
            double[] y = new double[] { 0, 1, 2, 3, 4 };
            double[] e = new double[] { 0, 1, 2, 3, 4 };
            double[] _1st = new double[] { 0, 1, 2, 3, 4 };
            double[] _2nd = new double[] { 0, 1, 2, 3, 4 };
            sut.InterpolateToFrameEndTimes(x1, x2, y, e, _1st, _2nd);

            Print(x1);
            Print(x2);
            Print(y);
            Print(e);
            Print(_1st);
            Print(_2nd);

            double[] out1 = new double[] { 0.5, 1.5, 2.5, 3.5, 4.5 };
            double[] out2 = new double[] { 0, 1, 3, 6, 10 };
            double[] out3 = new double[] { 0, 0.5, 2.5, 7, 15 };
            Assert.AreEqual(e, out1);
            Assert.AreEqual(_1st, out2);
            Assert.AreEqual(_2nd, out3);
        }

        private delegate void DoIt();

        /// <summary>
        /// Test for thrown expections.
        /// </summary>
        [Test]
        public void Test3_1()
        {
            double[] size3 = new double[] { 0, 1, 2 };
            double[] size4 = new double[] { 0, 1, 2, 4 };
            double[] notAscending = new double[] { 3, 2, 1 };
            LinearInterpolation sut = new LinearInterpolation();

            double[] notNeeded5;
            double[] notNeeded6;
            List<DoIt> list = new List<DoIt>();
            list.Add(delegate() { LinearInterpolation.Interpolate(size3, size4, size3, out size3, out notNeeded5, out notNeeded6); });
            //list.Add(delegate() { sut.Interpolate(notAscending, notAscending, size3, size3, null, null); });

            foreach (DoIt test in list)
            {
                try
                {
                    test();
                    Assert.Fail("No exception thrown!");
                }
                catch (TPCException e)
                {
                    Console.WriteLine(e.Message);
                }
                catch (Exception e)
                {
                    Assert.Fail(e.Message);
                }
            }
        }
    }
}
