﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using NUnit.Framework;

namespace TPClib.Model
{
    /// <summary>
    /// Test cases for Linear Regression
    /// </summary>
    [TestFixture]
    public class NUnitTestbench_LinearRegression
    {
        double error_margin = 0.0001;
        
        /// <summary>
        /// 1.1 Linear Regression, input: ten points generated in Mathematica
        /// </summary>
        [Test]
        public void Test1_1_LinearRegression()
        {
            double k, b;

            double[] x = new double[] {0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
            double[] y = new double[] {2.09398, 2.15858, 2.22792, 2.34269, 2.48365, 2.59691, 2.67669, 2.80106, 2.95851, 3.01561, 3.10235};

            LinearRegression.Fit(x, y, out k, out b);

            Assert.AreEqual(k, 1.07014, error_margin);
            Assert.AreEqual(b, 2.05202, error_margin);
        }

        /// <summary>
        /// 1.2 Linear Regression, input: ten points generated in Mathematica
        /// </summary>
        [Test]
        public void Test1_2_LinearRegression()
        {
            double k, b;

            double[] x = new double[] {0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
            double[] y = new double[] {3.17499, 3.24464, 3.51393, 3.7859, 3.93878, 4.16972, 4.26695, 4.41512, 4.75548, 4.99898, 5.03056};

            LinearRegression.Fit(x, y, out k, out b);

            Assert.AreEqual(k, 1.9642, error_margin);
            Assert.AreEqual(b, 3.13562, error_margin);
        }
    }
}
