﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using System.IO;

namespace TPClib.Model
{
    /// <summary>
    /// The Vector class How-To Documentation.
    /// </summary>
    [TestFixture]
    public class NUnitTestbench_Matrix
    {
        /// <summary>
        /// Test Column() and Row()
        /// </summary>
        [Test]
        public void Test2_1_Matrix()
        {
            Matrix m = new Matrix(2, 2);
            m[0, 0] = 1; m[0, 1] = 2;
            m[1, 0] = 3; m[1, 1] = 4;

            Vector a = m.GetColumn(0);
            Assert.AreEqual(1, a[0]);
            Assert.AreEqual(3, a[1]);

            Vector b = m.GetColumn(1);
            Assert.AreEqual(2, b[0]);
            Assert.AreEqual(4, b[1]);

            a = m.GetRow(0);
            Assert.AreEqual(1, a[0]);
            Assert.AreEqual(2, a[1]);

            b = m.GetRow(1);
            Assert.AreEqual(3, b[0]);
            Assert.AreEqual(4, b[1]);
        }

        /// <summary>
        /// Test matrix dimensions
        /// </summary>
        [Test]
        public void Test2_2_Matrix()
        {
            Matrix m = new Matrix(3, 2);
            m[0, 0] = 1; m[0, 1] = 2;
            m[1, 0] = 3; m[1, 1] = 4;
            m[2, 0] = 5; m[2, 1] = 6;

            Matrix n = new Matrix(3, 1);
            Assert.AreEqual(3, n.Rows);
            Assert.AreEqual(1, n.Columns);

            Matrix l = new Matrix(1, 3);
            Assert.AreEqual(1, l.Rows);
            Assert.AreEqual(3, l.Columns);

            Console.WriteLine(n);
        }

        /// <summary>
        /// Matrix.Copy
        /// </summary>
        [Test]
        public void Test2_3_MatrixCopy()
        {
            Matrix m = new Matrix(2, 2);
            m[0, 0] = 1; m[0, 1] = 2;
            m[1, 0] = 3; m[1, 1] = 4;

            Matrix n = new Matrix(m);
            // change original
            m[0, 0] = -1; m[0, 1] = -2;
            m[1, 0] = -3; m[1, 1] = -4;

            // but the copied remains the same.
            Assert.AreEqual(1, n[0, 0]);
            Assert.AreEqual(2, n[0, 1]);
            Assert.AreEqual(3, n[1, 0]);
            Assert.AreEqual(4, n[1, 1]);

            // but the copied remains the same.
            Assert.AreEqual(-1, m[0, 0]);
            Assert.AreEqual(-2, m[0, 1]);
            Assert.AreEqual(-3, m[1, 0]);
            Assert.AreEqual(-4, m[1, 1]);

            Console.WriteLine(m.ToString());
        }

        /// <summary>
        /// Matrix.Copy
        /// </summary>
        [Test]
        public void Test2_4_MatrixCopy2()
        {
            Matrix a = new Matrix(3, 2);
            a[0, 0] = 3; a[0, 1] = 1;
            a[1, 0] = 2; a[1, 1] = 2;
            a[2, 0] = 1; a[2, 1] = 3;

            Matrix b = new Matrix(4, 3);
            Matrix c = b;

            b.Copy(a);
            Assert.AreEqual(a.Columns, b.Columns);
            Assert.AreEqual(a.Rows, b.Rows);

            Assert.AreEqual(3, b[0, 0]);
            Assert.AreEqual(2, b[1, 0]);
            Assert.AreEqual(1, b[2, 0]);
            Assert.AreEqual(1, b[0, 1]);
            Assert.AreEqual(2, b[1, 1]);
            Assert.AreEqual(3, b[2, 1]);

            c[0, 0] = 33;
            Assert.AreEqual(33, b[0, 0]);
        }

        private Matrix SquareMatrix(int dim)
        {
            Matrix m = new Matrix(dim);
            for (int k = 1, j = 0; j < m.Columns; j++)
            {
                for (int i = 0; i < m.Rows; i++, k++)
                {
                    m[j, i] = k;
                }
            }
            return m;
        }

        /// <summary>
        /// No exception thrown
        /// </summary>
        [Test]
        public void Test3_1()
        {
            Matrix m = SquareMatrix(3);

            Console.WriteLine(m);

            bool[] fitted = new bool[] { false, true, true };
            Matrix.CovarianceSort(m, 3, fitted);
            Console.WriteLine(m);

            double[] table = { m[0, 1], m[0, 2], m[1, 0], m[2, 0] };
            foreach (double a in table) Assert.AreEqual(a, 0);


        }

        /// <summary>
        /// No exception thrown
        /// </summary>
        [Test]
        public void Test3_2()
        {
            Matrix m = SquareMatrix(10);
            bool[] x = new bool[] { true, false, true, true, false, true, false, true, true, false };
            Matrix.CovarianceSort(m, 10, x);
        }

        /// <summary>
        /// No exception thrown
        /// </summary>
        [Test]
        public void Test3_3()
        {
            Matrix m = SquareMatrix(3);

            Console.WriteLine(m);

            bool[] x = new bool[] { false, false, false };
            Matrix.CovarianceSort(m, 3, x);

            Console.WriteLine(m);
        }

        /// <summary>
        /// No exception thrown
        /// </summary>
        [Test]
        public void Test3_4()
        {
            Matrix m = SquareMatrix(3);

            bool[] x = new bool[] { true, true, true };
            Matrix.CovarianceSort(m, 3, x);

            for (int k = 1, j = 0; j < m.Columns; j++)
            {
                for (int i = 0; i < m.Rows; i++)
                {
                    Assert.AreEqual(m[j, i], k++);
                }
            }

        }
    }
}
