﻿using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace TPClib.Model
{
    /// <summary>
    /// 
    /// </summary>
    [TestFixture]
    public class NUnitTestbench_Transformation
    {
        /// <summary>
        /// Matrix 3x3 Inversion test.
        /// </summary>
        [Test]
        public void Test1_1_Matrix3x3Inversion()
        {
            Matrix m = new Matrix(3);
            m[0, 0] = 1; m[0, 1] = 2; m[0, 2] = 3;
            m[1, 0] = 0; m[1, 1] = 1; m[1, 2] = 4;
            m[2, 0] = 5; m[2, 1] = 6; m[2, 2] = 0;

            // Expected precalculated matrix
            Matrix e = new Matrix(3);
            e[0, 0] = -24; e[0, 1] = 18; e[0, 2] = 5;
            e[1, 0] = 20; e[1, 1] = -15; e[1, 2] = -4;
            e[2, 0] = -5; e[2, 1] = 4; e[2, 2] = 1;

            Matrix o = Transformation.Inverse3x3(m);

            Console.WriteLine("expected:\n" + e);
            Console.WriteLine("output:\n" + o);

            Assert.IsTrue(o.Equals(e, 1e-10));
        }

        /// <summary>
        /// Matrix 3x3 Inversion test.
        /// </summary>
        [Test]
        public void Test1_2_Matrix4x4Inversion()
        {
            Matrix m = new Matrix(4);
            m[0, 0] = 1.8477590650;
            m[0, 1] = -0.29289321880;
            m[0, 2] = 0.70710678120;
            m[0, 3] = 0;
            m[1, 0] = 0;
            m[1, 1] = 1.8477590650;
            m[1, 2] = 0.76536686470;
            m[1, 3] = 5;
            m[2, 0] = -0.76536686470;
            m[2, 1] = -0.70710678120;
            m[2, 2] = 1.7071067810;
            m[2, 3] = 0;
            m[3, 0] = 0;
            m[3, 1] = 5;
            m[3, 2] = 0;
            m[3, 3] = 1;

            // Expected precalculated matrix
            Matrix e = new Matrix(4);
            e[0, 0] = 0.46193976630;
            e[0, 1] = 0;
            e[0, 2] = -0.19134171620;
            e[0, 3] = 0;
            e[1, 0] = 0.0069415884030;
            e[1, 1] = -0.043792010440;
            e[1, 2] = 0.016758476870;
            e[1, 3] = 0.21896005220;
            e[2, 0] = 0.20998208120;
            e[2, 1] = -0.018139244650;
            e[2, 2] = 0.50694158840;
            e[2, 3] = 0.090696223250;
            e[3, 0] = -0.034707942010;
            e[3, 1] = 0.21896005220;
            e[3, 2] = -0.083792384330;
            e[3, 3] = -0.094800261080;

            Matrix o = Transformation.Inverse4x4(m);

            Console.WriteLine("expected:\n" + e);
            Console.WriteLine("output:\n" + o);

            Assert.IsTrue(o.Equals(e, 1e-10));
        }
    }
}
