﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using NUnit.Framework;

namespace TPClib.Model
{
    /// <summary>
    /// The Vector class tests.
    /// </summary>
    [TestFixture]
    public class NUnitTestbench_Vector
    {
        /// <summary>
        /// Casting from vector to array and vice verse.
        /// In here vector size is 100 and it is filled with
        /// random numbers.
        /// </summary>
        [Test]
        public void Test1_1()
        {
            int size = 100;
            Random rand = new Random();
            double[] dbl1, dbl2;
            Vector v1, v2;

            dbl1 = new double[size];
            v1 = new Vector(size);

            for (int i = 0; i < size; i++)
            {
                v1[i] = dbl1[i] = rand.NextDouble()*Double.MaxValue;
            }

            v2 = (Vector)dbl1;
            dbl2 = (double[])v1;

            Assert.AreEqual(v1, v2);
            for (int i = 0; i < size; i++)
            {
                Assert.AreEqual(dbl1[i], dbl2[i]);
                Assert.AreEqual(dbl1[i], v1[i]);
                Assert.AreEqual(dbl1[i], v2[i]);
            }
        }

        /// <summary>
        /// Tests that initialization works.
        /// </summary>
        [Test]
        public void Test1_2()
        {
            Vector a = new double[] { 1, 2, 3 };
            Vector b = new Vector(a);
            a[0] = 0;
            a[1] = 0;
            a[2] = 0;
            Assert.AreEqual(1, b[0]);
            Assert.AreEqual(2, b[1]);
            Assert.AreEqual(3, b[2]);
            Assert.AreEqual(a.Length, b.Length);
        }

        /// <summary>
        /// Tests subtraction method.
        /// </summary>
        [Test]
        public void Test1_3()
        {
            Vector v = new double[] { 2, 2, 2, 2 };
            Vector u = new double[] { 1, 1, 1, 1, };
            Vector w = v - u;
            Assert.AreEqual(1, w[0]);
            Assert.AreEqual(1, w[3]);
        }

        /// <summary>
        /// Tests fill method.
        /// </summary>
        [Test]
        public void Test1_4()
        {
            Vector v = Vector.Fill(5, 123.123);
            for (int i = 0; i < v.Dim; i++)
            {
                Assert.AreEqual(123.123, v[i]);
            }
        }
    }
}
