﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/

using System;
using System.Collections.Generic;
using System.Text;

namespace TPClib.Model
{
    /// <summary>
    /// Interferface for a single differential equation system.
    /// see RungeKutta and ODESolver
    /// </summary>
    public interface ODE
    {
        /// <summary>
        /// Returns the array of state variables associated with this diff eq
        /// </summary>
        /// <returns>state variable</returns>
        double[] GetVars();

        /// <summary>
        /// Evaluates the differential equations.
        /// </summary>
        /// <param name="input">the current variables in array 'x'</param>
        /// <param name="output">change rates for each diffeq in array 'change'</param>
        void Evaluate(double[] input, double[] output);
    }
}
