﻿/******************************************************************************
 *
 * Copyright (c) 2009 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System.Collections.Generic;
using System.Runtime.InteropServices;

namespace TPClib.Model
{

    /// <summary>
    /// Each optimization method have unique amount of parameters, for example ITGO has
    /// Iterations, Samples and Sample size. 
    /// </summary>
    [ClassInterface(ClassInterfaceType.AutoDual), ComSourceInterfacesAttribute(typeof(Ifile))]
    public class OptimizationInfo
    {
        /// <summary>
        /// Name of method, for example PowellBrent, ITGO
        /// </summary>
        public string MethodName;
        /// <summary>
        /// Name of parameter, for example "Sample size", "ITGOsamples"
        /// </summary>
        public List<string> ParameterName;
        /// <summary>
        /// Value of parameter
        /// </summary>
        public List<double> ParameterValue;
        /// <summary>
        /// Shows the info as string
        /// </summary>
        /// <returns>Info object as string</returns>
        public override string ToString()
        {
            return MethodName;
        }
    }
}
