﻿/******************************************************************************
 *
 * Copyright (c) 2009 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;

namespace TPClib.Model
{
    [ClassInterface(ClassInterfaceType.AutoDual), ComSourceInterfacesAttribute(typeof(Ifile))]
    public class OriginalInputModel : Model
    {
        private const double kg = 0.5 / 60.0;

        Vector simulated;
        double[] times;
        int samples;


        protected override ModelInfo GetInfo()
        {
            ModelInfo info = new ModelInfo("OriginalInputModel", "This is RTCMModel description...", false);

            List<ModelParameter> parameters = new List<ModelParameter>();
            parameters.Add(new ModelParameter("A", 0, 400000, 1));
            parameters.Add(new ModelParameter("ka", 2, 20.4, 4.99));
            parameters.Add(new ModelParameter("t1", -10, 50, 0));
            parameters.Add(new ModelParameter("t2", 10, 80, 20));
            info.Parameters = parameters.ToArray();
            info.ClassType = this.GetType();

            return info;
        }

        public override void Create(Vector times, params Vector[] Reference)
        {
            this.times = times;
            simulated = new Vector(times.Length);
            samples = times.Length;
        }

        public override int Samples
        {
            get { return samples; }
        }

        public OriginalInputModel()
        {
            Info = GetInfo();
        }


        public override Vector Simulate(double[] p)
        {
            double A = p[0];
            double ka = p[1] / 60.0;
            double t1 = p[2];
            double t2 = p[3];


            for (int i = 0; i < samples; i++)
            {

                /*double x = times[i];
                double y;

                if (x < t1) y = 0.0d;
                else if (x <= t2) y = 1.0d - Math.Exp(ka * (t1 - x));
                else y = Math.Exp(ka * (t1 - t2)) - 2.0d * Math.Exp(ka * (t1 - x)) + Math.Exp(ka * (t2 - x));

                simulated[i] = (y * A);*/
       
                double y1, y2, y, xx;

                xx = times[i];

                if (xx <= t1)
                {
                    y = 0.0;
                }
                else if (xx <= t2)
                {
                    y = (1.0 - Math.Exp(kg * (t1 - xx))) / kg
                      + (Math.Exp(ka * (t1 - xx)) - Math.Exp(kg * (t1 - xx))) / (ka - kg);
                }
                else
                {
                    y1 = (Math.Exp(kg * (t2 - xx)) - Math.Exp(kg * (t1 - xx)) + Math.Exp(ka * (t1 - t2))
                    - Math.Exp(ka * (t1 - t2)) * Math.Exp(kg * (t2 - xx))) / kg;
                    y2 = (-Math.Exp(ka * (t1 - t2)) * Math.Exp(kg * (t2 - xx))
                    + Math.Exp(ka * (t2 - xx)) + Math.Exp(kg * (t1 - xx))
                    - Math.Exp(kg * (t2 - xx)) - 2.0 * Math.Exp(ka * (t1 - xx))
                    + 2.0 * Math.Exp(ka * (t1 - t2)) * Math.Exp(kg * (t2 - xx))) / (kg - ka);
                    y = y1 + y2;
                }

                simulated[i] = (y * A * kg);


            }

            return simulated;
        }



    
    }
}
