﻿/******************************************************************************
 *
 * Copyright (c) 2008 Turku PET Centre
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * Turku PET Centre hereby disclaims all copyright interest in the program.
 * Juhani Knuuti
 * Director, Professor
 * 
 * Turku PET Centre, Turku, Finland, http://www.turkupetcentre.fi/
 * 
 ******************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using TPClib.Curve;
using NUnit.Framework;

namespace TPClib.ROI
{
    /// <summary>
    /// Class for ImageTool ROI file unit tests
    /// </summary>
    [TestFixture]
    public class NUnitTestBench_ImageToolROIFile
    {
        //private string imagefile = "P:\\Data\\ROI\\ImageTool\\oneplane.v";
        private string Ppath = "P:\\Data\\ROI\\ImageTool\\";
        private string Cpath = "ROITest\\ImageTool\\";



        /// <summary>
        /// Read ImageTool ROI file from disk and Write it by another name. Make DFT file
        /// from it with img2dft.exe and compare result to original
        /// </summary>
        [Test]
        public void Test1_0_ReadWrite_File()
        {
            System.IO.Directory.CreateDirectory(Cpath);            
            ROIFile file = new ROIFile();
            file.ReadFile( Ppath + "roi_regional.roi");
            Console.WriteLine("OriginalROis="+file.VOIs.Count);

            ImageToolROIFile file2 = new ImageToolROIFile();
            for( int i=0; i<file.VOIs.Count; i++ ) file2.VOIs.Add( file.VOIs[i] );
            file2.WriteFile( Cpath + "Test1_0.roi");
            TestHelpers.getStdOut(@"P:\\bin\\windows\\img2dft.exe", Ppath+"image.v "+Cpath+"Test1_0.roi "+Cpath+"Test1_0.dft");
            Assert.IsTrue( 
                TestHelpers.getStdOut(@"P:\\bin\\windows\\dftmatch.exe", Ppath + "regional.dft " + Cpath + "Test1_0.dft") == 0
            );
        }

        /// <summary>
        /// Check that class recognizes wrong files from correct ones. Test with binary file, empty file, another roi
        /// file
        /// </summary>
        [Test]
        public void Test1_1_Recognize_format()
        {
            ImageToolROIFile file = new ImageToolROIFile();
            file.filename = Ppath + "image.v"; // binary file 
            Assert.IsFalse( file.CheckFormat() );

            file.filename = Ppath + "empty.roi"; // empty file 
            Assert.IsFalse( file.CheckFormat() );

            file.filename = "P:\\Data\\ROI\\Imadeus\\roi.roi"; // wrong roi file 
            Assert.IsFalse( file.CheckFormat() );

            file.filename = Ppath + "roi_regional.roi"; // empty file 
            Assert.IsTrue(file.CheckFormat());
        }

        /// <summary>
        /// Test all shapes that them all will be written and read correctly.
        /// Rect,ellipse,trace and circle
        /// </summary>
        [Test]
        public void Test1_2_Different_Shapes()
        {
            ImageToolROIFile file = new ImageToolROIFile();
            file.ReadFile(Ppath + "roi_shapes.roi");

            ImageToolROIFile file2 = new ImageToolROIFile();
            file2.VOIs.Add( file.VOIs[0] );
            file2.WriteFile(Cpath + "Test1_2.roi");
            TestHelpers.getStdOut(@"P:\\bin\\windows\\img2dft.exe", Ppath + "image.v " + Cpath + "Test1_2.roi " + Cpath + "Test1_2.dft");
            Assert.IsTrue(
                TestHelpers.getStdOut(@"P:\\bin\\windows\\dftmatch.exe", Ppath + "shapes.dft " + Cpath + "Test1_2.dft") == 0
            );
        }

    }
}




/*
TPClib.Image.Ecat7File file = new TPClib.Image.Ecat7File(Ppath + "oneplane.v");
file.ReadFile();

file.filename = Ppath + "image.v";
//Image.Image image = file.getImage();
            
int xx = 5;

for( int y=0; y<file.image.height; y++ )
{
    for (int x = 0; x < file.image.width; x++)
    {
        file.image[x, y, 0] = (float)(xx % 66);
        Console.Write(file.image[x, y, 0]+" ");
        xx++;
    }
    Console.WriteLine();
}
           
file.WriteFile();*/




/*for (int w = 0; w < file.VOIs[0].Count; w++)
{
    ROI roi = file.VOIs[0].GetRoi(w);
    roi.Fill(7, 8);

    Console.WriteLine(file.VOIs[0].Count);
    ROI_Matrix matrix = roi.GetMatrix();
    Console.WriteLine("ROI=" + roi.ToString());

    Assert.IsTrue( matrix.Equals( transpose(correctRegional[w]) ) );

    Console.WriteLine(matrix.ToString());
}*/
